#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interfaces.h"


namespace morpheo              {
namespace behavioural          {
  
  Signal * Interfaces::get_clock (void)
  {
    Signal * clock = NULL;
    
    if (not _list_interface->empty())
      {
	list<Interface_fifo*>::iterator i = _list_interface->begin();
	
	while (i != _list_interface->end())
	  {
	    Signal * sig = (*i)->get_clock ();

	    if (sig != NULL)
	      {
		if (clock != NULL)
		  throw ErrorMorpheo ("<Interfaces.get_clock> : find too many clock.");
		clock = sig;
	      }
	    ++i;
	  }
      }

    if (clock == NULL)
      throw ErrorMorpheo ("<Interfaces.get_clock> : no clock find.");
    
    return clock;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
