#ifndef morpheo_behavioural_generic_counter_Counter_h
#define morpheo_behavioural_generic_counter_Counter_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Include/ToString.h"
#include "Include/Debug.h"

#include "Behavioural/Generic/Counter/include/Parameters.h"
#include "Behavioural/Generic/Counter/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Generic/Counter/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Component.h"

using namespace std;

namespace morpheo {
namespace behavioural {
namespace generic {
namespace counter {

  class Counter 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;
  public    : SC_IN (Tdata_t)              **  in_COUNTER_DATA         ;
  public    : SC_IN (Tcontrol_t)           **  in_COUNTER_ADDSUB       ;
  public    : SC_OUT(Tdata_t)              ** out_COUNTER_DATA         ;
    
    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Counter);

  public  :          Counter              (sc_module_name                              name,
#else					       
  public  :          Counter              (string                                      name,
#endif					       
#ifdef STATISTICS
					   morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
					   Parameters                                  param );
					       
  public  :          Counter              (Parameters param );
  public  :          ~Counter             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                (void);
#endif
  public  : void     genMealy                  (void);
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl * & vhdl);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace counter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
