/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Parameters.h"
#include <sstream>
using namespace std;

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  string Parameters::print (uint32_t depth)
  {
    string tab = string(depth,'\t');
    ostringstream msg;
    msg << tab << "<shifter>" << endl
	<< tab << "\t<size_data   value=\"" << _size_data   << "\" />" << endl
	<< tab << "\t<nb_port     value=\"" << _nb_port     << "\" />" << endl
	<< tab << "\t<shift_value value=\"" << _shift_value << "\" />" << endl
	<< tab << "\t<rotate      value=\"" << toString_rotate    (_rotate   ) << "\" />" << endl
	<< tab << "\t<direction   value=\"" << toString_direction (_direction) << "\" />" << endl
	<< tab << "\t<carry       value=\"" << toString_carry     (_carry    ) << "\" />" << endl
	<< tab << "\t<!-- port_completion is type bool : " << toString(_type_completion_bool) << " -->" << endl
      	<< tab << "</shifter>" << endl;
    
    return msg.str();
  };

  ostream& operator<< (ostream& output_stream ,
		       morpheo::behavioural::generic::shifter::Parameters & x)
  {
    output_stream << x.print(0);
    
    return output_stream;
  };

}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
