#ifndef morpheo_behavioural_XML_h
#define morpheo_behavioural_XML_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <math.h>
#include <list>
#include "Include/ToString.h"
#include "Include/Debug.h"

using namespace std;

namespace morpheo     {
namespace behavioural {

  // Virtual Class - Interface of each component
  class XML
  {
    // -----[fields ]----------------------------------------------------
  private  : const string     _name              ;
  private  : string           _filename_extension;
  private  : string           _body              ;
  private  : list<string>     _list_balise_name  ;

    // -----[methods ]---------------------------------------------------
  public   :                  XML                 (string name);
  public   :                  ~XML                (void);
	
  public   : bool             balise_open         (string name); // no attribut
  public   : bool             balise_open_begin   (string name);
  public   : bool             balise_open_end     (void);      
  public   : bool             balise_close        (void);      
  public   : bool             singleton           (string name); // no attribut
  public   : bool             singleton_begin     (string name);
  public   : bool             singleton_end       (void);
  public   : bool             attribut            (string name, string value);
  public   : bool             insert_XML          (XML    xml );

  public   : void             filename_extension  (string extension);
  public   : void             generate_file       (void);
  public   : void             generate_file       (string encoding);
  public   : string           get_body            (void);
  public   : string           get_body            (uint32_t depth);

  public   : bool             comment             (string text);
  public   : bool             text                (string text);
					          
  private  : string           indent              (uint32_t depth );
  private  : string           indent              (void);
  private  : uint32_t         depth               (void);
					          
  private  : void             header              (string encoding);
  };
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
