#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface_fifo.h"

namespace morpheo              {
namespace behavioural          {

  string Interface_fifo::testbench_test (Vhdl * & vhdl,
					 string   counter_name,
					 string   reset_name  )
  {
    log_printf(FUNC,Behavioural,"testbench_test","Begin");
    string test_name;
    
    if (_test_exhaustive == true)
      test_name = Interface::testbench_test(vhdl,counter_name,reset_name);
    else
      {
	vhdl->set_body("");
	vhdl->set_body("-- Test partial");
	vhdl->set_body("");

	       test_name        = testbench_test_name        (vhdl);
	string test_name_tmp    = test_name+"_tmp";
	string test_name_ok     = testbench_test_ok          (vhdl);
 	string test_transaction = testbench_test_transaction (vhdl);

	vhdl->set_signal(test_name_tmp,1);

	if (_list_cycle->empty()== false)
	  {
	    vhdl->set_body ("with "+counter_name+" select");
	    vhdl->set_body ("\t"+test_name_tmp+" <=");
	
	    list<uint32_t>::iterator i = _list_cycle->begin();
	    
	    while (i != _list_cycle->end())
	      {
		vhdl->set_body ("\t"+test_transaction+" and "+test_name_ok+" when "+toString(*i)+",");
		++i;
	      }
	    vhdl->set_body ("\tnot "+test_transaction+" when others;");
	  }
	else
	  vhdl->set_body (test_name_tmp+" <= not "+test_transaction+";");
	
	vhdl->set_body("");
	vhdl->set_body(test_name + " <= '1' when ("+reset_name+" = '0') else "+test_name_tmp+";");

#ifdef VHDL_TESTBENCH_ASSERT
	if (_list_cycle->empty()== false)
	  {
	    vhdl->set_body("");
	    vhdl->set_body("-- Assert ...");
	    vhdl->set_body("");

	    uint32_t                 j = 0;
	    list<uint32_t>::iterator i = _list_cycle->begin();
	    
	    while (i != _list_cycle->end())
	      {
		vhdl->set_body("assert not ( ("+counter_name+" = "+toString(*i)+")) report \"***** <"+_name+"> interface's test number "+toString(j)+" *****\" severity NOTE;");
		j++;
		++i;
	      }

	    vhdl->set_body("");
	  }
#endif
      }

    log_printf(FUNC,Behavioural,"testbench_test","End");

    return test_name;

  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
