#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {

  void Two_Level_Branch_Predictor_Glue::genMealy_branch_complete_ack (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_branch_complete_ack","Begin");

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	// Ackwnolegde
	bool bht_ack = (not _param._have_bht) or PORT_READ(in_BRANCH_COMPLETE_BHT_ACK [i]);
	bool pht_ack = (not _param._have_pht) or PORT_READ(in_BRANCH_COMPLETE_PHT_ACK [i]);		  

	PORT_WRITE (out_BRANCH_COMPLETE_ACK [i], bht_ack and pht_ack);
      }

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_branch_complete_ack","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
