#ifdef VHDL

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>
using namespace std;

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_architecture"
  string Vhdl::get_architecture (uint32_t depth      ,
				 string   name       ,
				 string   entity_name)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    string        tab = string(depth,'\t');
    ostringstream text;

    text << tab << "architecture " << name << " of " << entity_name << " is" << endl
	 << tab << get_type     (depth+1)                                    << endl
	 << tab << get_signal   (depth+1)                                    << endl
	 << tab << get_alias    (depth+1)                                    << endl
	 << tab << "begin"                                                   << endl
	 << tab << get_body     (depth+1)                                    << endl
	 << tab << "end " << name << ";"                                     << endl;

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
