#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {

  void RegisterFile::genMealy_read (void)
  {
    log_printf(FUNC,Register_File,"genMealy_read","Begin");

#ifdef STATISTICS
    _stat_nb_read = 0;
#endif    

    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	// Have a write?
 	if ( PORT_READ(in_READ_ENABLE[i]) == 1)
 	  {
	    Taddress_t address = PORT_READ(in_READ_ADDRESS[i]);
	    Tdata_t    data    = REGISTER_READ(reg_DATA[address]);

	    log_printf(TRACE,Register_File,"genMealy_read","[%d] -> %.8x",static_cast<uint32_t>(address),static_cast<uint32_t>(data));

#ifdef STATISTICS
	    _stat_nb_read ++;
#endif    
	    // Write in registerFile
	    PORT_WRITE(out_READ_DATA[i],data);
 	  }
	else
	  {
	    //log_printf(TRACE,Register_File,"genMealy_read","Read [%d] : No   transaction",i);
	    PORT_WRITE(out_READ_DATA[i],0);
	  }
      }
    log_printf(FUNC,Register_File,"genMealy_read","End");
	
  };

}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
