#include "sort_file.h"
#include "sort_file_dynamic.h"
#include "entry_test.h"
#include <iostream>

using namespace hierarchy_memory::sort_file;
using namespace std;

void test_ko (int val)
{
  cout << "***** Test(" << val << ") KO *****" << endl;
  exit (val);
};

void test_ok ()
{
  cout << "***** Test OK *****" << endl;
  exit (0);
};

static uint32_t num_test = 1;

template <class T>
void test(T exp1, T exp2)
{
  if (exp1 != exp2)
    {
      cerr << "exp1 : " << exp1 << endl;
      cerr << "exp2 : " << exp2 << endl;
      test_ko (num_test);
    }
  num_test ++;
};

int main ()
{
  {
    cout << "<main> Test de \"Sort_File\"" << endl;

    cout << " * creation d'une Sort_File de taille 5" << endl;
    Sort_File <Entry> my_Sort_File = Sort_File <Entry> (param_t("my_file",5));
    my_Sort_File.reset();
    cout << my_Sort_File << endl;

    cout << " * must be empty ..." << endl;
    if ( (my_Sort_File.empty() == false) ||
	 (my_Sort_File.full () == true ) )
      test_ko (1);

    cout << " * insert 6 elements" << endl;
  
    if (my_Sort_File.push((uint32_t)5,Entry(1,1,0x44444444)) != true ) test_ko (2); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)6,Entry(2,2,0x55555555)) != true ) test_ko (3); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)3,Entry(3,3,0x22222222)) != true ) test_ko (4); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)5,Entry(4,4,0x33333333)) != true ) test_ko (5); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)1,Entry(5,5,0x11111111)) != true ) test_ko (6); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)4,Entry(6,6,0x00000BAD)) != false) test_ko (7); cout << my_Sort_File << endl;

    cout << " * must be full  ..." << endl;
    if ( (my_Sort_File.empty() == true ) ||
	 (my_Sort_File.full () == false) )
      test_ko (8);

    cout << " * extract 6 elements" << endl;
    if (my_Sort_File.pop().data != 0x11111111) test_ko (9);
    if (my_Sort_File.pop().data != 0x22222222) test_ko (10);
    if (my_Sort_File.pop().data != 0x33333333) test_ko (11);
    if (my_Sort_File.pop().data != 0x44444444) test_ko (12);
    if (my_Sort_File.pop().data != 0x55555555) test_ko (13);

    cout << " * ajout de 8 elements (reset apres le deuxieme)" << endl;

    if (my_Sort_File.push((uint32_t)5,Entry(1,1,0x44444444)) != true ) test_ko (14); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)6,Entry(2,2,0x55555555)) != true ) test_ko (15); cout << my_Sort_File << endl;
    my_Sort_File.reset();							        
    if (my_Sort_File.push((uint32_t)3,Entry(3,3,0x22222222)) != true ) test_ko (16); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)5,Entry(4,4,0x33333333)) != true ) test_ko (17); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)5,Entry(1,1,0x44444444)) != true ) test_ko (18); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)7,Entry(2,2,0x55555555)) != true ) test_ko (19); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)1,Entry(5,5,0x11111111)) != true ) test_ko (20); cout << my_Sort_File << endl;
    if (my_Sort_File.push((uint32_t)4,Entry(6,6,0x00000BAD)) != false) test_ko (21); cout << my_Sort_File << endl;

    cout << " * 3 transitions" << endl;
  
    my_Sort_File.transition(); cout << my_Sort_File << endl;
    my_Sort_File.transition(); cout << my_Sort_File << endl;
    my_Sort_File.transition(); cout << my_Sort_File << endl;

    cout << " * extract 1 element" << endl;

    if (my_Sort_File.pop().data != 0x11111111) test_ko (22);  
  
    cout << my_Sort_File << endl;

    for (uint32_t it = 0; it < my_Sort_File.nb_slot_use(); it ++)
      {
	slot_t<Entry> val = my_Sort_File.read(it);
	cout << val.delay << " " << val.data << endl;
      }

    cout << " * Test pop(n)" << endl;
  
    test <uint32_t> (my_Sort_File.pop(1).data, 0x44444444);
    test <uint32_t> (my_Sort_File.pop(2).data, 0x55555555);
    test <uint32_t> (my_Sort_File.pop(0).data, 0x22222222);
    test <uint32_t> (my_Sort_File.pop(0).data, 0x33333333);
  }

  {
    cout << "<main> Test de \"Sort_File_Dynamic\"" << endl;

    cout << " * creation d'une Sort_File de taille 5" << endl;
    Sort_File_Dynamic <Entry> my_Sort_File_Dynamic = Sort_File_Dynamic <Entry> (param_t("my_file_dynamic",5));
    my_Sort_File_Dynamic.reset();
    cout << my_Sort_File_Dynamic << endl;

    cout << " * must be empty ..." << endl;
    if ( (my_Sort_File_Dynamic.empty() == false) ||
	 (my_Sort_File_Dynamic.full () == true ) )
      test_ko (1);

    if (my_Sort_File_Dynamic.push(5,Entry(1,1, 4)) != true ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(6,Entry(2,2, 6)) != true ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(3,Entry(3,3, 2)) != true ) test_ko ( 4); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(5,Entry(4,4, 5)) != true ) test_ko ( 5); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(1,Entry(5,5, 1)) != true ) test_ko ( 6); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(4,Entry(6,6, 3)) != true ) test_ko ( 7); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(9,Entry(1,1,12)) != true ) test_ko ( 8); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(6,Entry(2,2, 7)) != true ) test_ko ( 9); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(7,Entry(3,3, 8)) != true ) test_ko (10); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(7,Entry(4,4, 9)) != true ) test_ko (11); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(8,Entry(5,5,11)) != true ) test_ko (12); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(7,Entry(6,6,10)) != true ) test_ko (13); cout << my_Sort_File_Dynamic << endl;

    if (my_Sort_File_Dynamic.pop().data !=  1 ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  2 ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  3 ) test_ko ( 4); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  4 ) test_ko ( 5); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  5 ) test_ko ( 6); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  6 ) test_ko ( 7); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  7 ) test_ko ( 8); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  8 ) test_ko ( 9); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  9 ) test_ko (10); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data != 10 ) test_ko (11); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data != 11 ) test_ko (12); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data != 12 ) test_ko (13); cout << my_Sort_File_Dynamic << endl;


    if (my_Sort_File_Dynamic.push(5,Entry(1,1, 4)) != true ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(6,Entry(2,2, 6)) != true ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(3,Entry(3,3, 2)) != true ) test_ko ( 4); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(5,Entry(4,4, 5)) != true ) test_ko ( 5); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(1,Entry(5,5, 1)) != true ) test_ko ( 6); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(4,Entry(6,6, 3)) != true ) test_ko ( 7); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(9,Entry(1,1,12)) != true ) test_ko ( 8); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(6,Entry(2,2, 7)) != true ) test_ko ( 9); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(7,Entry(3,3, 8)) != true ) test_ko (10); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(7,Entry(4,4, 9)) != true ) test_ko (11); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(8,Entry(5,5,11)) != true ) test_ko (12); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(7,Entry(6,6,10)) != true ) test_ko (13); cout << my_Sort_File_Dynamic << endl;

    if (my_Sort_File_Dynamic.pop().data !=  1 )              test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  2 )              test_ko ( 3); cout << my_Sort_File_Dynamic << endl;

    if (my_Sort_File_Dynamic.push(0,Entry(1,1, 1)) != true ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(2,2, 2)) != true ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  1 )              test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  2 )              test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(1,1, 1)) != true ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(2,2, 2)) != true ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  1 )              test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  2 )              test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(1,1, 1)) != true ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(2,2, 2)) != true ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  1 )              test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  2 )              test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(1,1, 1)) != true ) test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.push(0,Entry(2,2, 2)) != true ) test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  1 )              test_ko ( 2); cout << my_Sort_File_Dynamic << endl;
    if (my_Sort_File_Dynamic.pop().data !=  2 )              test_ko ( 3); cout << my_Sort_File_Dynamic << endl;
    

  }

  test_ok ();
    
}
