#ifndef SERVICE_OPEN_H
#define SERVICE_OPEN_H

#include "../sim2os.h"

namespace hierarchy_memory {
  namespace sim2os {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~[service_open ]~~~~~
    void *
    Sim2os::
    service_open ()
    {
      if (have_all_arguments(3) == false)
	{
	  cerr << "<" << NAME << "> Usage : int open(const char *pathname, int flags, mode_t mode);" << endl;
	  return NULL;
	}
  
      const char *pathname = (const char *) convert_address(arguments[1]);
      int         flags    = (int)          arguments[2];
      mode_t      mode     = (mode_t)       arguments[3];
      void *      result   = (void *)       open(pathname,flags,mode);
      error                = errno;

      cout << "\n\t***** service : open          *****"          << endl;
      cout << "\tpathname  : " <<                       pathname << endl;
      cout << "\tflags /8  : " << oct << (unsigned int) flags    << endl;
      cout << "\tflags /10 : " << dec << (unsigned int) flags    << endl;
      cout << "\tflags /16 : " << hex << (unsigned int) flags    << endl;
      cout << "\tmode  /8  : " << oct << (unsigned int) mode     << endl;
      cout << "\tmode  /10 : " << dec << (unsigned int) mode     << endl;
      cout << "\tmode  /16 : " << hex << (unsigned int) mode     << endl;
      cout << "\tresult    : " << dec << (unsigned int) result   << endl;
      cout << "\terrno     : " <<        (unsigned int) error    << endl;

      return      result;
    }

  };};
#endif //SERVICE_OPEN_H
