#ifdef SYSTEMC
#ifndef morpheo_behavioural_generic_shifter_Type_h
#define morpheo_behavioural_generic_shifter_Type_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Common/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {

  typedef enum { without_rotate      ,
		 internal_rotate     ,
		 external_rotate     } rotate_t;

  typedef enum { internal_right_shift,
		 internal_left_shift ,
		 external_direction  } direction_t;

  typedef enum { internal_logic      ,
		 internal_arithmetic ,
		 external_carry      ,
		 external_completion } carry_t;       

  typedef uint32_t     Tdata_t     ;
  typedef uint32_t     Tshift_t    ;
  typedef bool         Tdirection_t;
  typedef bool         Ttype_t     ;
  typedef bool         Tcarry_t    ;

  // A lot of constant
  const   Tdirection_t _right      = false;
  const   Tdirection_t _left       = true ;

  const   Ttype_t      _shift      = false;
  const   Ttype_t      _rotate     = true ;

  const   Tcarry_t     _logic      = false;
  const   Tcarry_t     _arithmetic = true ;

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
#endif
