#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {


  void Select_Priority_Fixed::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Select_Priority_Fixed,"vhdl_body","Begin");
    vhdl->set_body ("");

    vhdl->set_body("internal_entity <=");
    for (uint32_t i=0; i<_param._nb_entity; i++)
      {
	vhdl->set_body("\t"+std_logic_conv(_param._size_entity+1,i)+" when in_VAL_"+toString(i)+"='1' else");
      }
    vhdl->set_body("\t"+std_logic_conv(_param._size_entity+1,1<<_param._size_entity)+";");
    vhdl->set_body ("");

    if (_param._encoding_one_hot)
      {
	for (uint32_t i=0; i<_param._nb_entity; i++)
	  vhdl->set_body("out_ACK_"+toString(i)+" <= '1' when internal_entity"+std_logic_range(_param._size_entity+1)+" = "+std_logic_conv(_param._size_entity+1,i)+" else '0';");
	vhdl->set_body ("");
      }

    if (_param._encoding_compact)
      {
	vhdl->set_body ("out_ENTITY     <=     internal_entity"+std_logic_range(_param._size_entity-1,                  0)+";");
	vhdl->set_body ("out_ENTITY_ACK <= not internal_entity"+std_logic_range(_param._size_entity  ,_param._size_entity)+";");
      }	   
    
    log_printf(FUNC,Select_Priority_Fixed,"vhdl_body","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
