#ifndef DICO_H
#define DICO_H

#include "bool.h"

//=====[ dico_t ]==========================================

typedef struct dico_st 
{
  void           * key;
  void           * data;
  
  struct dico_st * previous;
  struct dico_st * next;
} dico_t;

//=====[ function ]========================================

dico_t * dico_add     (dico_t * dico, 
		       void   * key ,
		       void   * data);

dico_t * dico_del     (dico_t * dico, 
		       void   * key );

bool     dico_present (dico_t * dico, 
		       void   * key );

void *   dico_give    (dico_t * dico, 
		       void   * key );

#endif //!DICO_H
