#ifndef morpheo_tools_viewer_parser_h
#define morpheo_tools_viewer_parser_h

#include <qxml.h>
#include <qdom.h>
#include <iostream>
#include <list>
#include <iterator>

#include <qlist.h>
#include "Tools/Viewer/Bdd/include/BaseV.h"
#include "Tools/Viewer/Bdd/include/BaseP.h"
#include "Tools/Viewer/Bdd/include/Entity.h"
#include "Tools/Viewer/Bdd/include/Architecture.h"
#include "Tools/Viewer/Bdd/include/Component.h"
#include "Tools/Viewer/Bdd/include/Port.h"
#include "Tools/Viewer/Bdd/include/PortMap.h"


#include "Tools/Viewer/Bdd/include/Param.h"
#include "Tools/Viewer/Bdd/include/LimitParam.h"
#include "Tools/Viewer/Bdd/include/Group.h"

#define LEVEL_MAX 8

using namespace std;

namespace morpheo{
namespace tools{
namespace viewer{
namespace parser{     

class Parse
{
private:
  string s;
  string absolutePath;
  string toplevel;

  morpheo::tools::viewer::bdd::BaseV *base;
  morpheo::tools::viewer::bdd::BaseP *pos;
  morpheo::tools::viewer::bdd::Entity *ent[LEVEL_MAX];
  morpheo::tools::viewer::bdd::Architecture *arch[LEVEL_MAX];
  morpheo::tools::viewer::bdd::Component *ctemp[LEVEL_MAX];
  morpheo::tools::viewer::bdd::Param *param;
  morpheo::tools::viewer::bdd::Group *group;

  morpheo::tools::viewer::bdd::LimitParam *limit;

  void parser_pos(QDomNode n,int level);
  void parser_limitparam(QDomNode n);
  void parser_param(QDomNode n,int level);
  morpheo::tools::viewer::bdd::Param *createAddP(string namegrp,string nameparam);
  void createParam();

public:
  
  Parse(void);
  ~Parse(void);
  int open_file_param(string name);
  int open_file(string name,int level);
  /*save configuration file
   * name: file name
   * type: 0 ->user save a file 
   *       1 ->function apply() temporary save
   */
  int save_file(string name,int type);
  morpheo::tools::viewer::bdd::BaseV *getBaseV();
  string getTopLevelName();
  string getAbsolutePath();
  void refresh();  
  /*Close and erase baseV*/
  void closeBaseV();
  
 


};//end class parse
};//end parser
};//end viewer
};//end tools
};//end morpheo


#endif
