#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  void RegisterFile_Multi_Banked::partial_crossbar_genMealy_read (void)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"partial_crossbar_genMealy_read","Begin");

    bool read_port_use [_param._nb_bank][_param._nb_port_read_by_bank];

    for (uint32_t i=0; i<_param._nb_bank; i++)
      for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	read_port_use [i][j]=false;

    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	bool val = PORT_READ(in_READ_VAL    [i]);
	bool ack = false;

	log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_read","read[%d] : %d",i,val);

	if (val == true)
	  {
	    // Compute the adress of the bank
	    Taddress_t address = PORT_READ(in_READ_ADDRESS[i]);
	    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_read"," * address   : %d",address);
	    Taddress_t bank    = address_bank    (address);
	    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_read"," * bank      : %d",bank   );

// 	    // Search loop
// 	    for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
// 	      {
	    
	    uint32_t j = _param._link_port_read_to_bank_read [i];

		// find a unbusy port on this bank
		if (read_port_use[bank][j] == false)
		  {
		    // find !!!
		    read_port_use[bank][j] = true;
		    ack                    = true;
		    
		    Taddress_t num_reg = address_num_reg (address);

		    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_read"," * num_reg   : %d",num_reg);
		    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_read"," * bank_port : %d",j);

		    Tdata_t    data    = REGISTER_READ(reg_DATA[bank][num_reg]);
		    
		    log_printf(TRACE,RegisterFile_Multi_Banked,"full_crossbar_genMealy_read"," * data      : %d",data);

		    PORT_WRITE(out_READ_DATA [i], data);

// 		    break;
		  }
// 	      }
	  }

	// Write output
	PORT_WRITE(out_READ_ACK [i], ack);
      }

    log_printf(FUNC,RegisterFile_Multi_Banked,"partial_crossbar_genMealy_read","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//#endif
