/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {


#ifdef SYSTEMC
  Meta_Predictor_Glue::Meta_Predictor_Glue (sc_module_name name,
#else
  Meta_Predictor_Glue::Meta_Predictor_Glue (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::meta_predictor_glue::Parameters param ):
			      _name              (name)
			      ,_param            (param)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,Meta_Predictor_Glue,"Meta_Predictor_Glue","Begin");

    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","Allocation");
    allocation ();

#ifdef STATISTICS
    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","Allocation of statistics");

    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","VHDL's generation");
    vhdl();
#endif

#ifdef SYSTEMC
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
#endif

    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","method - genMealy_predict_ack");
    SC_METHOD (genMealy_predict_ack);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	sensitive << *(in_PREDICT_PREDICTOR_2_ACK [i]);
	
	if (_param._have_meta_predictor)
	  {
	    sensitive << *(in_PREDICT_PREDICTOR_0_ACK [i])
		      << *(in_PREDICT_PREDICTOR_1_ACK [i]);
	  }			           
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	(*(out_PREDICT_ACK [i])) (*(in_PREDICT_PREDICTOR_2_ACK [i]));
	
	if (_param._have_meta_predictor)
	  {
	(*(out_PREDICT_ACK [i])) (*(in_PREDICT_PREDICTOR_0_ACK [i]));
	(*(out_PREDICT_ACK [i])) (*(in_PREDICT_PREDICTOR_1_ACK [i]));
	  }			           
      }
#endif    

    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","method - genMealy_predict_history");
    SC_METHOD (genMealy_predict_history);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._predictor_2_have_bht)
	sensitive << *(in_PREDICT_PREDICTOR_2_BHT_HISTORY [i]);
	if (_param._predictor_2_have_pht)
	sensitive << *(in_PREDICT_PREDICTOR_2_PHT_HISTORY [i]);

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_bht)
	sensitive << *(in_PREDICT_PREDICTOR_1_BHT_HISTORY [i]);
	if (_param._predictor_1_have_pht)
	sensitive << *(in_PREDICT_PREDICTOR_1_PHT_HISTORY [i]);

	if (_param._predictor_0_have_bht)
	sensitive << *(in_PREDICT_PREDICTOR_0_BHT_HISTORY [i]);
	if (_param._predictor_0_have_pht)
	sensitive << *(in_PREDICT_PREDICTOR_0_PHT_HISTORY [i]);
	  }			           
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._predictor_2_have_bht)
	(*(out_PREDICT_HISTORY    [i])) (*(in_PREDICT_PREDICTOR_2_BHT_HISTORY [i]));
	if (_param._predictor_2_have_pht)
	(*(out_PREDICT_HISTORY    [i])) (*(in_PREDICT_PREDICTOR_2_PHT_HISTORY [i]));

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_bht)
	(*(out_PREDICT_HISTORY    [i])) (*(in_PREDICT_PREDICTOR_1_BHT_HISTORY [i]));
	if (_param._predictor_1_have_pht)
	(*(out_PREDICT_HISTORY    [i])) (*(in_PREDICT_PREDICTOR_1_PHT_HISTORY [i]));

	if (_param._predictor_0_have_bht)
	(*(out_PREDICT_HISTORY    [i])) (*(in_PREDICT_PREDICTOR_0_BHT_HISTORY [i]));
	if (_param._predictor_0_have_pht)
	(*(out_PREDICT_HISTORY    [i])) (*(in_PREDICT_PREDICTOR_0_PHT_HISTORY [i]));
	  }			           

	if (_param._predictor_2_have_bht)
	(*(out_PREDICT_DIRECTION  [i])) (*(in_PREDICT_PREDICTOR_2_BHT_HISTORY [i]));
	if (_param._predictor_2_have_pht)
	(*(out_PREDICT_DIRECTION  [i])) (*(in_PREDICT_PREDICTOR_2_PHT_HISTORY [i]));

	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_1_have_bht)
	(*(out_PREDICT_DIRECTION  [i])) (*(in_PREDICT_PREDICTOR_1_BHT_HISTORY [i]));
	if (_param._predictor_1_have_pht)
	(*(out_PREDICT_DIRECTION  [i])) (*(in_PREDICT_PREDICTOR_1_PHT_HISTORY [i]));

	if (_param._predictor_0_have_bht)
	(*(out_PREDICT_DIRECTION  [i])) (*(in_PREDICT_PREDICTOR_0_BHT_HISTORY [i]));
	if (_param._predictor_0_have_pht)
	(*(out_PREDICT_DIRECTION  [i])) (*(in_PREDICT_PREDICTOR_0_PHT_HISTORY [i]));
	  }			           
      }
#endif    

    if (_param._have_meta_predictor)
      {
    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","method - genMealy_branch_complete_val");
    SC_METHOD (genMealy_branch_complete_val);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	sensitive << *(in_BRANCH_COMPLETE_VAL       [i])
		  << *(in_BRANCH_COMPLETE_HISTORY   [i])
		  << *(in_BRANCH_COMPLETE_DIRECTION [i]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	(*(out_BRANCH_COMPLETE_PREDICTOR_2_VAL       [i])) (*(in_BRANCH_COMPLETE_VAL       [i]));
	(*(out_BRANCH_COMPLETE_PREDICTOR_2_VAL       [i])) (*(in_BRANCH_COMPLETE_HISTORY   [i]));
	(*(out_BRANCH_COMPLETE_PREDICTOR_2_VAL       [i])) (*(in_BRANCH_COMPLETE_DIRECTION [i]));

	(*(out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION [i])) (*(in_BRANCH_COMPLETE_VAL       [i]));
	(*(out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION [i])) (*(in_BRANCH_COMPLETE_HISTORY   [i]));
	(*(out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION [i])) (*(in_BRANCH_COMPLETE_DIRECTION [i]));
      }
#endif    
      }

    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","method - genMealy_branch_complete_ack");
    SC_METHOD (genMealy_branch_complete_ack);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	sensitive << *(in_BRANCH_COMPLETE_PREDICTOR_2_ACK [i]);
	
	if (_param._have_meta_predictor)
	  {
	    sensitive << *(in_BRANCH_COMPLETE_PREDICTOR_0_ACK [i])
		      << *(in_BRANCH_COMPLETE_PREDICTOR_1_ACK [i]);
	  }			           
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	(*(out_BRANCH_COMPLETE_ACK [i])) (*(in_BRANCH_COMPLETE_PREDICTOR_2_ACK [i]));
	
	if (_param._have_meta_predictor)
	  {
	(*(out_BRANCH_COMPLETE_ACK [i])) (*(in_BRANCH_COMPLETE_PREDICTOR_0_ACK [i]));
	(*(out_BRANCH_COMPLETE_ACK [i])) (*(in_BRANCH_COMPLETE_PREDICTOR_1_ACK [i]));
	  }			           
      }
#endif    

    log_printf(INFO,Meta_Predictor_Glue,"Meta_Predictor_Glue","method - genMealy_branch_complete_history");
    SC_METHOD (genMealy_branch_complete_history);
    dont_initialize ();
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	sensitive << *(in_BRANCH_COMPLETE_HISTORY [i]);
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._predictor_2_have_bht)
	 (*(out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY [i])) (*( in_BRANCH_COMPLETE_HISTORY    [i]));
	if (_param._predictor_2_have_pht)
	 (*(out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY [i])) (*( in_BRANCH_COMPLETE_HISTORY    [i]));
		
	if (_param._have_meta_predictor)
	  {
	    if (_param._predictor_1_have_bht)
	 (*(out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY [i])) (*( in_BRANCH_COMPLETE_HISTORY    [i]));
	    if (_param._predictor_1_have_pht)
	 (*(out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY [i])) (*( in_BRANCH_COMPLETE_HISTORY    [i]));
													   
	    if (_param._predictor_0_have_bht)
	 (*(out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY [i])) (*( in_BRANCH_COMPLETE_HISTORY    [i]));
	    if (_param._predictor_0_have_pht)
	 (*(out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY [i])) (*( in_BRANCH_COMPLETE_HISTORY    [i]));
	  }			           
      }
#endif    

#endif
    log_printf(FUNC,Meta_Predictor_Glue,"Meta_Predictor_Glue","End");
  };
  
  Meta_Predictor_Glue::~Meta_Predictor_Glue (void)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"~Meta_Predictor_Glue","Begin");

#ifdef STATISTICS
    log_printf(INFO,Meta_Predictor_Glue,"~Meta_Predictor_Glue","Generate Statistics");
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    log_printf(INFO,Meta_Predictor_Glue,"~Meta_Predictor_Glue","Dealocation");
    deallocation ();
#endif

    log_printf(FUNC,Meta_Predictor_Glue,"~Meta_Predictor_Glue","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
