#ifndef morpheo_behavioural_Component_h
#define morpheo_behavioural_Component_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include <map>
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
//#include "Behavioural/include/Description.h"
#include "Behavioural/include/Entity.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

using namespace std;

namespace morpheo              {
namespace behavioural          {

  class Component
  {
    // -----[fields ]----------------------------------------------------
  private   : Entity              * _entity        ;
  private   : list<Entity *>      * _list_component;
    
    // -----[methods ]---------------------------------------------------
  public    :                       Component         (void);
  public    :                       Component         (const Component & component);
  public    :                       ~Component        ();

  public    : Entity *              set_entity        (string        name   
						       ,string        type  
#ifdef POSITION
						       ,schema_t      schema
#endif
						       );
  private   : string                get_entity        (void);

  public    : void                  set_component     (Component * component
#ifdef POSITION
						       ,uint32_t   pos_x  
						       ,uint32_t   pos_y  
						       ,uint32_t   size_x 
						       ,uint32_t   size_y 
#endif
						       );

  private   : string                get_component     (void);

  private   : Entity *              find_entity       (string name);
  private   : Interface *           find_interface    (string   name  , 
						       Entity * entity);

#ifdef VHDL
  public    : void                  vhdl_instance     (Vhdl * & vhdl);
#endif

  public    : void                  port_map          (string component_src ,
						       string port_src      ,
						       string component_dest,
						       string port_dest    );

#ifdef POSITION
  public    : void                  interface_map     (string component_src ,
						       string port_dest,
						       string component_dest,
						       string port_dest     );

  public    : XML                   toXML             (void);

  public    : void                  generate_file     (void);
#endif    
  public    : friend ostream&       operator<<        (ostream& output_stream,
  					  	       morpheo::behavioural::Component & x);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
