#ifndef ENTRY_H
#define ENTRY_H

#include <stdint.h>
#include <iostream>

using namespace std; // Utilisation de l'espace de nommage standard

namespace hierarchy_memory
{
  namespace sort_file
  {
    class Entry
    {
    public : uint32_t   trdid  ;  // number of thread
    public : uint32_t   pktid  ;  // number of packet
    public : uint32_t   nb_word;
    public : uint32_t   size_word;
    public : char    ** data   ;
    public : uint32_t   error  ;
      
      Entry () {};
      
      Entry (uint32_t   trdid    ,
	     uint32_t   pktid    ,
	     uint32_t   nb_word  ,
	     uint32_t   size_word,
	     char    ** data     ,
	     uint32_t   error 
	     )
      {
	this->trdid     = trdid;
	this->pktid     = pktid;
	this->nb_word   = nb_word;
	this->size_word = size_word;
	this->data      = new char * [nb_word];
	this->error     = error;

	for (uint32_t num_word = 0; num_word < nb_word; num_word++)
	  {
	    this->data[num_word] = new char [size_word];
	    memcpy(this->data[num_word],data[num_word],size_word);
	  }
      };
      
      friend ostream& operator<< (ostream& output_stream, Entry x)
      {
	output_stream << x.trdid              << " " 
		      << x.pktid              << " " 
		      << x.error              << " ";

	output_stream << hex;

	for (uint32_t it_nb_word = 0; it_nb_word < x.nb_word; it_nb_word ++)
	  {
	    for (uint32_t it_size_word = x.size_word; it_size_word > 0 ; it_size_word --)
	      output_stream << setw(2) << setfill('0') << (0xff & (static_cast<uint32_t>(x.data [it_nb_word][it_size_word-1])));
	    output_stream << " - ";
	  } 
	output_stream << dec;

	return output_stream;
      }
    };
  }; //sort_file
}; //hierarchy_memory
#endif //!ENTRY_H
