/*
 * $Id$
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION 64

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/SelfTest/include/test.h"
#include "Common/include/BitManipulation.h"
#include "Common/include/Test.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::two_level_branch_predictor_glue::Parameters param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

  try 
    {
      cout << param.print(1);
      param.test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      return;
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }
  Two_Level_Branch_Predictor_Glue * _Two_Level_Branch_Predictor_Glue = new Two_Level_Branch_Predictor_Glue (name.c_str(),
#ifdef STATISTICS
					     morpheo::behavioural::Parameters_Statistics(5,50),
#endif
					     param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                                 CLOCK ("clock", 1.0, 0.5);
  sc_signal<Tcontrol_t>                    NRESET;

  sc_signal<Tcontrol_t>                    PREDICT_BHT_ACK             [param._nb_prediction];
  sc_signal<Tcontrol_t>                    PREDICT_PHT_ACK             [param._nb_prediction];
  sc_signal<Tcontrol_t>                    PREDICT_ACK                 [param._nb_prediction];
  				           
  sc_signal<Taddress_t>                    PREDICT_ADDRESS             [param._nb_prediction];
  sc_signal<Tbht_history_t>                PREDICT_BHT_HISTORY         [param._nb_prediction];
  sc_signal<Taddress_t>                    PREDICT_BHT_ADDRESS         [param._nb_prediction];
  sc_signal<Taddress_t>                    PREDICT_PHT_ADDRESS         [param._nb_prediction];
  				           
  sc_signal<Tcontrol_t>                    BRANCH_COMPLETE_BHT_ACK     [param._nb_branch_complete];
  sc_signal<Tcontrol_t>                    BRANCH_COMPLETE_PHT_ACK     [param._nb_branch_complete];
  sc_signal<Tcontrol_t>                    BRANCH_COMPLETE_ACK         [param._nb_branch_complete];
  sc_signal<Taddress_t>                    BRANCH_COMPLETE_ADDRESS     [param._nb_branch_complete];
  sc_signal<Tbht_history_t>                BRANCH_COMPLETE_BHT_HISTORY [param._nb_branch_complete];
  sc_signal<Taddress_t>                    BRANCH_COMPLETE_BHT_ADDRESS [param._nb_branch_complete];
  sc_signal<Taddress_t>                    BRANCH_COMPLETE_PHT_ADDRESS [param._nb_branch_complete];
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Two_Level_Branch_Predictor_Glue" << endl;
  
  (*(_Two_Level_Branch_Predictor_Glue->in_CLOCK))        (CLOCK);
  (*(_Two_Level_Branch_Predictor_Glue->in_NRESET))       (NRESET);

  for (uint32_t i=0; i<param._nb_prediction; i++)
    {
      if (param._have_bht)
	{
      (*(_Two_Level_Branch_Predictor_Glue-> in_PREDICT_BHT_ACK             [i])) (PREDICT_BHT_ACK             [i]);
      (*(_Two_Level_Branch_Predictor_Glue->out_PREDICT_BHT_ADDRESS         [i])) (PREDICT_BHT_ADDRESS         [i]);
	}
      if (param._have_bht and param._have_pht)
      (*(_Two_Level_Branch_Predictor_Glue-> in_PREDICT_BHT_HISTORY         [i])) (PREDICT_BHT_HISTORY         [i]);
      if (param._have_pht)
	{
      (*(_Two_Level_Branch_Predictor_Glue-> in_PREDICT_PHT_ACK             [i])) (PREDICT_PHT_ACK             [i]);
      (*(_Two_Level_Branch_Predictor_Glue->out_PREDICT_PHT_ADDRESS         [i])) (PREDICT_PHT_ADDRESS         [i]);
	}
      (*(_Two_Level_Branch_Predictor_Glue->out_PREDICT_ACK                 [i])) (PREDICT_ACK                 [i]);
      (*(_Two_Level_Branch_Predictor_Glue-> in_PREDICT_ADDRESS             [i])) (PREDICT_ADDRESS             [i]);
    }
  for (uint32_t i=0; i<param._nb_branch_complete; i++)
    {
      if (param._have_bht)
	{
      (*(_Two_Level_Branch_Predictor_Glue-> in_BRANCH_COMPLETE_BHT_ACK     [i])) (BRANCH_COMPLETE_BHT_ACK     [i]);
      (*(_Two_Level_Branch_Predictor_Glue->out_BRANCH_COMPLETE_BHT_ADDRESS [i])) (BRANCH_COMPLETE_BHT_ADDRESS [i]);
	}
      if (param._have_bht and param._have_pht)
      (*(_Two_Level_Branch_Predictor_Glue-> in_BRANCH_COMPLETE_BHT_HISTORY [i])) (BRANCH_COMPLETE_BHT_HISTORY [i]);

      if (param._have_pht)
	{
      (*(_Two_Level_Branch_Predictor_Glue-> in_BRANCH_COMPLETE_PHT_ACK     [i])) (BRANCH_COMPLETE_PHT_ACK     [i]);
      (*(_Two_Level_Branch_Predictor_Glue->out_BRANCH_COMPLETE_PHT_ADDRESS [i])) (BRANCH_COMPLETE_PHT_ADDRESS [i]);
	}
      (*(_Two_Level_Branch_Predictor_Glue->out_BRANCH_COMPLETE_ACK         [i])) (BRANCH_COMPLETE_ACK         [i]);
      (*(_Two_Level_Branch_Predictor_Glue-> in_BRANCH_COMPLETE_ADDRESS     [i])) (BRANCH_COMPLETE_ADDRESS     [i]);
    }

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  cout << "<" << name << "> Start Simulation ............" << endl;
  // Initialisation

  Tcontrol_t predict_bht_ack;
  Tcontrol_t predict_pht_ack;

  Tcontrol_t branch_complete_bht_ack;
  Tcontrol_t branch_complete_pht_ack;
  
  srand(0);
  //srand(time(NULL));

  sc_start(0);

  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Initialisation" << endl;

  NRESET.write(1);

  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Test ack" << endl;

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      // Branch History Table
      if (param._have_bht)
	{
	  predict_bht_ack         = (rand()%2)!=0;
	  branch_complete_bht_ack = (rand()%2)!=0;

	}
      else
	{
	  predict_bht_ack         = 1;
	  branch_complete_bht_ack = 1;
	}

      // Pattern History Table
      if (param._have_pht)
	{
	  predict_pht_ack         = (rand()%2)!=0;
	  branch_complete_pht_ack = (rand()%2)!=0;
	}
      else
	{
	  predict_pht_ack         = 1;
	  branch_complete_pht_ack = 1;
	}
      
      for (uint32_t i=0; i<param._nb_prediction;      i++)
	{
	  PREDICT_BHT_ACK         [i] .write(predict_bht_ack);
	  PREDICT_PHT_ACK         [i] .write(predict_pht_ack);
	}
      
      for (uint32_t i=0; i<param._nb_branch_complete; i++)
	{
	  BRANCH_COMPLETE_BHT_ACK [i] .write(branch_complete_bht_ack);
	  BRANCH_COMPLETE_PHT_ACK [i] .write(branch_complete_pht_ack);
	}
      
      sc_start(0);

      // Test result
      for (uint32_t i=0; i<param._nb_prediction;      i++)
	TEST(Tcontrol_t,(predict_pht_ack & predict_bht_ack),PREDICT_ACK [i].read());

      for (uint32_t i=0; i<param._nb_branch_complete;      i++)
	TEST(Tcontrol_t,(branch_complete_pht_ack & branch_complete_bht_ack),BRANCH_COMPLETE_ACK [i].read());

      sc_start(1);
    }

  Taddress_t     predict_address;
  Tbht_history_t predict_bht_history;
  Taddress_t     branch_complete_address;
  Tbht_history_t branch_complete_bht_history;


  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} Test address" << endl;

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      predict_address             = rand()%(1<<param._size_address    );
      predict_bht_history         = 0;
      branch_complete_address     = rand()%(1<<param._size_address    );
      branch_complete_bht_history = 0;

      for (uint32_t i=0; i<param._nb_prediction; i++)
	PREDICT_ADDRESS         [i].write (predict_address);
      for (uint32_t i=0; i<param._nb_branch_complete; i++)
	BRANCH_COMPLETE_ADDRESS [i].write (branch_complete_address);

      // Branch History Table
      if (param._have_bht and param._have_pht)
	{
	  predict_bht_history         = rand()%(1<<param._bht_size_history);
	  branch_complete_bht_history = rand()%(1<<param._bht_size_history);
	  
	  for (uint32_t i=0; i<param._nb_prediction; i++)
	    PREDICT_BHT_HISTORY         [i].write(predict_bht_history);
	  for (uint32_t i=0; i<param._nb_branch_complete; i++)
	    BRANCH_COMPLETE_BHT_HISTORY [i].write(branch_complete_bht_history);
	}

      sc_start(0);

      // Branch History Table
      if (param._have_bht)
	{
	  for (uint32_t i=0; i<param._nb_prediction; i++)
	    TEST(Taddress_t,PREDICT_BHT_ADDRESS [i].read(),(predict_address & gen_mask<Taddress_t>(param._bht_size_address)));

	  for (uint32_t i=0; i<param._nb_branch_complete; i++)
	    TEST(Taddress_t,BRANCH_COMPLETE_BHT_ADDRESS [i].read(),(branch_complete_address & gen_mask<Taddress_t>(param._bht_size_address)));
	}

      // Pattern History Table
      if (param._have_pht)
	{
	  uint32_t shift = (param._have_bht==false)?0:(param._pht_size_address_shift);

	  for (uint32_t i=0; i<param._nb_prediction; i++)
	    TEST(Taddress_t,PREDICT_PHT_ADDRESS [i].read(),(((predict_address << shift) xor predict_bht_history) & gen_mask<Taddress_t>(param._pht_size_address)));
	  for (uint32_t i=0; i<param._nb_branch_complete; i++)
	    TEST(Taddress_t,BRANCH_COMPLETE_PHT_ADDRESS [i].read(), (((branch_complete_address << shift) xor branch_complete_bht_history) & gen_mask<Taddress_t>(param._pht_size_address)));
	}

      sc_start(1);	  
    }
  /********************************************************
   * Simulation - End
   ********************************************************/

  cout << "<" << name << "> ............ Stop Simulation" << endl;

#endif

  delete _Two_Level_Branch_Predictor_Glue;
}
