#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  void Signal::testbench_body (Vhdl * & vhdl,
			       string   counter_name,
			       string   reset_name  )
  {
    log_printf(FUNC,Behavioural,"testbench_body","Begin");

    // _list_value is empty if we don't trace

    if ((_presence_port == PORT_VHDL_YES_TESTBENCH_YES) or
	(_presence_port == PORT_VHDL_NO_TESTBENCH_YES ))
      if (_list_value->empty()== false)
	{
	  string separator;
	  if (_size == 1)
	    separator = "\'";
	  else
	    separator = "\"";
	  
	  string signame = (_direction==OUT)?(_name+"_test"):_name;
	  
	  vhdl->set_body ("");
	  vhdl->set_body ("with "+counter_name+" select");
	  vhdl->set_body ("\t"+signame+" <=");
	  
	  uint32_t cpt = 0;
	  list<string>::iterator i = _list_value->begin();
	  
	  while (i != _list_value->end())
	    {
	      list<string>::iterator j = i;
	      
	      ++i;
	      
	      vhdl->set_body ("\t"+separator+*j+separator+" when "+toString(cpt++)+",");
	    }
	  
	  if (_size == 1)
	    vhdl->set_body ("\t'0' when others;");
	  else
	    vhdl->set_body ("\t(others => '0') when others;");
	}
  
    log_printf(FUNC,Behavioural,"testbench_body","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
