#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {



#undef  FUNCTION
#define FUNCTION "Reservation_station::allocation"
  void Reservation_station::allocation (void)
  {
    string rename;

    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");

    _component   = new Component ();

    Entity * entity = _component->set_entity (_name       
					      ,"Reservation_station"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[Interface : "reservation_station_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface("reservation_station_in"
#ifdef POSITION
							       ,IN
							       ,EAST
							       ,"Input of reservation_station"
#endif
							       );
      
       in_RESERVATION_STATION_IN_VAL            = interface->set_signal_valack_in  (VAL);
      out_RESERVATION_STATION_IN_ACK            = interface->set_signal_valack_out (ACK);
       in_RESERVATION_STATION_IN_CONTEXT_ID     = interface->set_signal_in <Tcontext_t        > ("context_id"  ,_param->_size_context_id       );
       in_RESERVATION_STATION_IN_PACKET_ID      = interface->set_signal_in <Tpacket_t         > ("packet_id"   ,_param->_size_packet_id        );
       in_RESERVATION_STATION_IN_OPERATION      = interface->set_signal_in <Toperation_t      > ("operation"   ,_param->_size_operation        );
       in_RESERVATION_STATION_IN_TYPE           = interface->set_signal_in <Ttype_t           > ("type"        ,_param->_size_type             );
       in_RESERVATION_STATION_IN_HAS_IMMEDIAT   = interface->set_signal_in <Tcontrol_t        > ("has_immediat",1                             );
       in_RESERVATION_STATION_IN_IMMEDIAT       = interface->set_signal_in <Tgeneral_data_t   > ("immediat"    ,_param->_size_general_data     );
//     in_RESERVATION_STATION_IN_READ_RA        = interface->set_signal_in <Tcontrol_t        > ("read_ra"     ,1                             );
       in_RESERVATION_STATION_IN_NUM_REG_RA     = interface->set_signal_in <Tgeneral_address_t> ("num_reg_ra"  ,_param->_size_general_register );
       in_RESERVATION_STATION_IN_DATA_RA_VAL    = interface->set_signal_in <Tcontrol_t        > ("data_ra_val" ,1                             );
       in_RESERVATION_STATION_IN_DATA_RA        = interface->set_signal_in <Tgeneral_data_t   > ("data_ra"     ,_param->_size_general_data     );
//     in_RESERVATION_STATION_IN_READ_RB        = interface->set_signal_in <Tcontrol_t        > ("read_rb"     ,1                             );
       in_RESERVATION_STATION_IN_NUM_REG_RB     = interface->set_signal_in <Tgeneral_address_t> ("num_reg_rb"  ,_param->_size_general_register );
       in_RESERVATION_STATION_IN_DATA_RB_VAL    = interface->set_signal_in <Tcontrol_t        > ("data_rb_val" ,1                             );
       in_RESERVATION_STATION_IN_DATA_RB        = interface->set_signal_in <Tgeneral_data_t   > ("data_rb"     ,_param->_size_general_data     );
//     in_RESERVATION_STATION_IN_READ_RC        = interface->set_signal_in <Tcontrol_t        > ("read_rc"     ,1                             );
       in_RESERVATION_STATION_IN_NUM_REG_RC     = interface->set_signal_in <Tspecial_address_t> ("num_reg_rc"  ,_param->_size_special_register );
       in_RESERVATION_STATION_IN_DATA_RC_VAL    = interface->set_signal_in <Tcontrol_t        > ("data_rc_val" ,1                             );
       in_RESERVATION_STATION_IN_DATA_RC        = interface->set_signal_in <Tspecial_data_t   > ("data_rc"     ,_param->_size_special_data     );
       in_RESERVATION_STATION_IN_WRITE_RD       = interface->set_signal_in <Tcontrol_t        > ("write_rd"    ,1                             );
       in_RESERVATION_STATION_IN_NUM_REG_RD     = interface->set_signal_in <Tgeneral_address_t> ("num_reg_rd"  ,_param->_size_general_register );
       in_RESERVATION_STATION_IN_WRITE_RE       = interface->set_signal_in <Tcontrol_t        > ("write_re"    ,1                             );
       in_RESERVATION_STATION_IN_NUM_REG_RE     = interface->set_signal_in <Tspecial_address_t> ("num_reg_re"  ,_param->_size_special_register );      
     }

    // ~~~~~[Interface : "reservation_station_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~
    out_RESERVATION_STATION_OUT_VAL         = new SC_OUT(Tcontrol_t        ) * [_param->_size_queue];
     in_RESERVATION_STATION_OUT_ACK         = new SC_IN (Tcontrol_t        ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_CONTEXT_ID  = new SC_OUT(Tcontext_t        ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_PACKET_ID   = new SC_OUT(Tpacket_t         ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_OPERATION   = new SC_OUT(Toperation_t      ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_TYPE        = new SC_OUT(Ttype_t           ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_HAS_IMMEDIAT= new SC_OUT(Tcontrol_t        ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_IMMEDIAT    = new SC_OUT(Tgeneral_data_t   ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_DATA_RA     = new SC_OUT(Tgeneral_data_t   ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_DATA_RB     = new SC_OUT(Tgeneral_data_t   ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_DATA_RC     = new SC_OUT(Tspecial_data_t   ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_WRITE_RD    = new SC_OUT(Tcontrol_t        ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_NUM_REG_RD  = new SC_OUT(Tgeneral_address_t) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_WRITE_RE    = new SC_OUT(Tcontrol_t        ) * [_param->_size_queue];
    out_RESERVATION_STATION_OUT_NUM_REG_RE  = new SC_OUT(Tspecial_address_t) * [_param->_size_queue];
    
    for (uint32_t i=0; i<_param->_size_queue; i++)
      {
	Interface_fifo * interface = _interfaces->set_interface("reservation_station_out_"+toString(i)
#ifdef POSITION
								,OUT
								,WEST
								,"Output of reservation_station"
#endif
								);
	out_RESERVATION_STATION_OUT_VAL          [i] = interface->set_signal_valack_out(VAL);
	 in_RESERVATION_STATION_OUT_ACK          [i] = interface->set_signal_valack_in (ACK);
	out_RESERVATION_STATION_OUT_CONTEXT_ID   [i] = interface->set_signal_out<Tcontext_t        > ("context_id"  ,_param->_size_context_id);
	out_RESERVATION_STATION_OUT_PACKET_ID    [i] = interface->set_signal_out<Tpacket_t         > ("packet_id"   ,_param->_size_packet_id);
	out_RESERVATION_STATION_OUT_OPERATION    [i] = interface->set_signal_out<Toperation_t      > ("operation"   ,_param->_size_operation);
	out_RESERVATION_STATION_OUT_TYPE         [i] = interface->set_signal_out<Ttype_t           > ("type"        ,_param->_size_type);
	out_RESERVATION_STATION_OUT_HAS_IMMEDIAT [i] = interface->set_signal_out<Tcontrol_t        > ("has_immediat",1);
	out_RESERVATION_STATION_OUT_IMMEDIAT     [i] = interface->set_signal_out<Tgeneral_data_t   > ("immediat"    ,_param->_size_general_data);
	out_RESERVATION_STATION_OUT_DATA_RA      [i] = interface->set_signal_out<Tgeneral_data_t   > ("data_ra"     ,_param->_size_general_data);
	out_RESERVATION_STATION_OUT_DATA_RB      [i] = interface->set_signal_out<Tgeneral_data_t   > ("data_rb"     ,_param->_size_general_data);
	out_RESERVATION_STATION_OUT_DATA_RC      [i] = interface->set_signal_out<Tspecial_data_t   > ("data_rc"     ,_param->_size_special_data);
	out_RESERVATION_STATION_OUT_WRITE_RD     [i] = interface->set_signal_out<Tcontrol_t        > ("write_rd"    ,1);
	out_RESERVATION_STATION_OUT_NUM_REG_RD   [i] = interface->set_signal_out<Tgeneral_address_t> ("num_reg_rd"  ,_param->_size_general_register);
	out_RESERVATION_STATION_OUT_WRITE_RE     [i] = interface->set_signal_out<Tcontrol_t        > ("write_re"    ,1);
	out_RESERVATION_STATION_OUT_NUM_REG_RE   [i] = interface->set_signal_out<Tspecial_address_t> ("num_reg_re"  ,_param->_size_special_register);
      }

    // ~~~~~[Interface : "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     in_GPR_WRITE_VAL       = new SC_IN (Tcontrol_t        ) * [_param->_nb_gpr_write];
     in_GPR_WRITE_CONTEXT_ID= new SC_IN (Tcontext_t        ) * [_param->_nb_gpr_write];
     in_GPR_WRITE_NUM_REG   = new SC_IN (Tgeneral_address_t) * [_param->_nb_gpr_write];
     in_GPR_WRITE_DATA      = new SC_IN (Tgeneral_data_t   ) * [_param->_nb_gpr_write];

    for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
      {
        Interface_fifo * interface = _interfaces->set_interface("gpr_write_"+toString(i)
#ifdef POSITION
                                                                , IN  
                                                                ,SOUTH
                                                                , "Interface with write queue to bypass the write in the RegisterFile."
#endif
                                                                );

	 in_GPR_WRITE_VAL        [i] = interface->set_signal_valack_in (VAL);
	 in_GPR_WRITE_CONTEXT_ID [i] = interface->set_signal_in  <Tcontext_t        > ("context_id",_param->_size_context_id);
	 in_GPR_WRITE_NUM_REG    [i] = interface->set_signal_in  <Tgeneral_address_t> ("num_reg"   ,_param->_size_general_register);
	 in_GPR_WRITE_DATA       [i] = interface->set_signal_in  <Tgeneral_data_t   > ("data"      ,_param->_size_general_data);
      }

    // ~~~~~[Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     in_SPR_WRITE_VAL       = new SC_IN (Tcontrol_t        ) * [_param->_nb_spr_write];
     in_SPR_WRITE_CONTEXT_ID= new SC_IN (Tcontext_t        ) * [_param->_nb_spr_write];
     in_SPR_WRITE_NUM_REG   = new SC_IN (Tspecial_address_t) * [_param->_nb_spr_write];
     in_SPR_WRITE_DATA      = new SC_IN (Tspecial_data_t   ) * [_param->_nb_spr_write];

    for (uint32_t i=0; i<_param->_nb_spr_write; i++)
      {
        Interface_fifo * interface = _interfaces->set_interface("spr_write_"+toString(i)
#ifdef POSITION
                                                                , IN  
                                                                ,SOUTH
                                                                , "Interface with write queue to bypass the write in the RegisterFile."
#endif
                                                                );

	 in_SPR_WRITE_VAL        [i] = interface->set_signal_valack_in (VAL);
	 in_SPR_WRITE_CONTEXT_ID [i] = interface->set_signal_in  <Tcontext_t        > ("context_id",_param->_size_context_id);
	 in_SPR_WRITE_NUM_REG    [i] = interface->set_signal_in  <Tspecial_address_t> ("num_reg"   ,_param->_size_special_register);
	 in_SPR_WRITE_DATA       [i] = interface->set_signal_in  <Tspecial_data_t   > ("data"      ,_param->_size_special_data);
      }

    // ~~~~~[Interface : "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     in_BYPASS_WRITE_CONTEXT_ID  = new SC_IN (Tcontext_t        ) * [_param->_nb_bypass_write];
     in_BYPASS_WRITE_GPR_VAL     = new SC_IN (Tcontrol_t        ) * [_param->_nb_bypass_write];
     in_BYPASS_WRITE_GPR_NUM_REG = new SC_IN (Tgeneral_address_t) * [_param->_nb_bypass_write];
     in_BYPASS_WRITE_GPR_DATA    = new SC_IN (Tgeneral_data_t   ) * [_param->_nb_bypass_write];
     in_BYPASS_WRITE_SPR_VAL     = new SC_IN (Tcontrol_t        ) * [_param->_nb_bypass_write];
     in_BYPASS_WRITE_SPR_NUM_REG = new SC_IN (Tspecial_address_t) * [_param->_nb_bypass_write];
     in_BYPASS_WRITE_SPR_DATA    = new SC_IN (Tspecial_data_t   ) * [_param->_nb_bypass_write];

    for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
      {
        Interface_fifo * interface = _interfaces->set_interface("bypass_write_"+toString(i)
#ifdef POSITION
                                                                , IN  
                                                                ,NORTH
                                                                , "Interface with write queue to bypass the write in the RegisterFile."
#endif
                                                                );

	 in_BYPASS_WRITE_CONTEXT_ID [i] = interface->set_signal_in  <Tcontext_t        > ("context_id" ,_param->_size_context_id);
	 in_BYPASS_WRITE_GPR_VAL    [i] = interface->set_signal_valack_in ("gpr_val",VAL);
	 in_BYPASS_WRITE_GPR_NUM_REG[i] = interface->set_signal_in  <Tgeneral_address_t> ("gpr_num_reg",_param->_size_general_register);
	 in_BYPASS_WRITE_GPR_DATA   [i] = interface->set_signal_in  <Tgeneral_data_t   > ("gpr_data"   ,_param->_size_general_data);
	 in_BYPASS_WRITE_SPR_VAL    [i] = interface->set_signal_valack_in ("spr_val",VAL);
	 in_BYPASS_WRITE_SPR_NUM_REG[i] = interface->set_signal_in  <Tspecial_address_t> ("spr_num_reg",_param->_size_general_register);
	 in_BYPASS_WRITE_SPR_DATA   [i] = interface->set_signal_in  <Tspecial_data_t   > ("spr_data"   ,_param->_size_general_data);
      }

    // ~~~~~[Interface : "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     in_BYPASS_MEMORY_VAL         = new SC_IN (Tcontrol_t        ) * [_param->_nb_bypass_memory];
     in_BYPASS_MEMORY_CONTEXT_ID  = new SC_IN (Tcontext_t        ) * [_param->_nb_bypass_memory];
     in_BYPASS_MEMORY_NUM_REG     = new SC_IN (Tgeneral_address_t) * [_param->_nb_bypass_memory];
     in_BYPASS_MEMORY_DATA        = new SC_IN (Tgeneral_data_t   ) * [_param->_nb_bypass_memory];

    for (uint32_t i=0; i<_param->_nb_bypass_memory; i++)
      {
        Interface_fifo * interface = _interfaces->set_interface("bypass_memory_"+toString(i)
#ifdef POSITION
                                                                , IN  
                                                                , NORTH
                                                                , "Interface with load/store unit to bypass the write in the RegisterFile."
#endif
                                                                );

	 in_BYPASS_MEMORY_VAL        [i] = interface->set_signal_valack_in (VAL);
	 in_BYPASS_MEMORY_CONTEXT_ID [i] = interface->set_signal_in  <Tcontext_t        > ("context_id" ,_param->_size_context_id);
	 in_BYPASS_MEMORY_NUM_REG    [i] = interface->set_signal_in  <Tgeneral_address_t> ("num_reg"    ,_param->_size_general_register);
	 in_BYPASS_MEMORY_DATA       [i] = interface->set_signal_in  <Tgeneral_data_t   > ("data"       ,_param->_size_general_data);
      }


    // ~~~~~[internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   
    internal_RESERVATION_STATION_OUT_VAL = new Tcontrol_t [_param->_size_queue];

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif
    _queue_control = new morpheo::behavioural::generic::queue_control::Queue_Control::Queue_Control(_param->_size_queue);
    _queue         = new Treservation_station_entry_t [_param->_size_queue];

    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
