/*
 * $Id$
 *
 * [Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str)                                                                       \
{                                                                                        \
  cout << "{"+toString(static_cast<uint32_t>(sc_simulation_time()))+"} " << str << endl; \
} while(0)

static uint32_t cycle = 0;

#define SC_START(cycle_offset)                                          \
do                                                                      \
{                                                                       \
/*cout << "SC_START (begin)" << endl;*/                                 \
                                                                        \
  uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time()); \
  if (cycle_current != cycle)                                           \
    {                                                                   \
      cycle = cycle_current;                                            \
      cout << "##########[ cycle "<< cycle << " ]" << endl;             \
    }                                                                   \
                                                                        \
  if (cycle_current > CYCLE_MAX)                                        \
    {                                                                   \
      TEST_KO("Maximal cycles Reached");                                \
    }                                                                   \
  sc_start(cycle_offset);                                               \
/*cout << "SC_START (end  )" << endl;*/                                 \
} while(0)

void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::Parameters * _param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Register_unit * _Register_unit = new Register_unit (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                               * in_CLOCK;
  sc_signal<Tcontrol_t>                  * in_NRESET;

    // ~~~~~[Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        >   **  in_GPR_READ_VAL                 ;
  sc_signal<Tcontrol_t        >   ** out_GPR_READ_ACK                 ;
  sc_signal<Tcontext_t        >   **  in_GPR_READ_OOO_ENGINE_ID       ;
  sc_signal<Tgeneral_address_t>   **  in_GPR_READ_NUM_REG             ;
  sc_signal<Tgeneral_data_t   >   ** out_GPR_READ_DATA                ;
  sc_signal<Tcontrol_t        >   ** out_GPR_READ_DATA_VAL            ;

    // ~~~~~[Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        >   **  in_GPR_WRITE_VAL                ;
  sc_signal<Tcontrol_t        >   ** out_GPR_WRITE_ACK                ;
  sc_signal<Tcontext_t        >   **  in_GPR_WRITE_OOO_ENGINE_ID      ;
  sc_signal<Tgeneral_address_t>   **  in_GPR_WRITE_NUM_REG            ;
  sc_signal<Tgeneral_data_t   >   **  in_GPR_WRITE_DATA               ;

    // ~~~~~[Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        >   **  in_SPR_READ_VAL                 ;
  sc_signal<Tcontrol_t        >   ** out_SPR_READ_ACK                 ;
  sc_signal<Tcontext_t        >   **  in_SPR_READ_OOO_ENGINE_ID       ;
  sc_signal<Tspecial_address_t>   **  in_SPR_READ_NUM_REG             ;
  sc_signal<Tspecial_data_t   >   ** out_SPR_READ_DATA                ;
  sc_signal<Tcontrol_t        >   ** out_SPR_READ_DATA_VAL            ;

    // ~~~~~[Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        >   **  in_SPR_WRITE_VAL                ;
  sc_signal<Tcontrol_t        >   ** out_SPR_WRITE_ACK                ;
  sc_signal<Tcontext_t        >   **  in_SPR_WRITE_OOO_ENGINE_ID      ;
  sc_signal<Tspecial_address_t>   **  in_SPR_WRITE_NUM_REG            ;
  sc_signal<Tspecial_data_t   >   **  in_SPR_WRITE_DATA               ;
    
    // ~~~~~[Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        >  ***  in_INSERT_ROB_VAL               ;
  sc_signal<Tcontrol_t        >  *** out_INSERT_ROB_ACK               ;
  sc_signal<Tcontrol_t        >  ***  in_INSERT_ROB_RD_USE            ;
  sc_signal<Tgeneral_address_t>  ***  in_INSERT_ROB_RD_NUM_REG        ; // use=1 : status[num_reg]<- 0
  sc_signal<Tcontrol_t        >  ***  in_INSERT_ROB_RE_USE            ;
  sc_signal<Tspecial_address_t>  ***  in_INSERT_ROB_RE_NUM_REG        ;

    // ~~~~~[Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sc_signal<Tcontrol_t        >  ***  in_RETIRE_ROB_VAL               ;
  sc_signal<Tcontrol_t        >  *** out_RETIRE_ROB_ACK               ;
  sc_signal<Tcontrol_t        >  ***  in_RETIRE_ROB_RD_OLD_USE        ; 
  sc_signal<Tgeneral_address_t>  ***  in_RETIRE_ROB_RD_OLD_NUM_REG    ; // old_use=1 : status[old_num_reg]<- 0
  sc_signal<Tcontrol_t        >  ***  in_RETIRE_ROB_RD_NEW_USE        ;
  sc_signal<Tgeneral_address_t>  ***  in_RETIRE_ROB_RD_NEW_NUM_REG    ; // new_use=1 : status[new_num_reg]<- 1
  sc_signal<Tcontrol_t        >  ***  in_RETIRE_ROB_RE_OLD_USE        ; 
  sc_signal<Tspecial_address_t>  ***  in_RETIRE_ROB_RE_OLD_NUM_REG    ;
  sc_signal<Tcontrol_t        >  ***  in_RETIRE_ROB_RE_NEW_USE        ;
  sc_signal<Tspecial_address_t>  ***  in_RETIRE_ROB_RE_NEW_NUM_REG    ;

  string rename = "signal";

  in_CLOCK                                = new sc_clock ("clock", 1.0, 0.5);
  in_NRESET                               = new sc_signal<Tcontrol_t> ("NRESET");


    // ~~~~~[Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      in_GPR_READ_VAL                 = new sc_signal<Tcontrol_t        > * [_param->_nb_gpr_read];
     out_GPR_READ_ACK                 = new sc_signal<Tcontrol_t        > * [_param->_nb_gpr_read];
      in_GPR_READ_OOO_ENGINE_ID       = new sc_signal<Tcontext_t        > * [_param->_nb_gpr_read];
      in_GPR_READ_NUM_REG             = new sc_signal<Tgeneral_address_t> * [_param->_nb_gpr_read];
     out_GPR_READ_DATA                = new sc_signal<Tgeneral_data_t   > * [_param->_nb_gpr_read];
     out_GPR_READ_DATA_VAL            = new sc_signal<Tcontrol_t        > * [_param->_nb_gpr_read];
     
     for (uint32_t i=0; i<_param->_nb_gpr_read; i++)
       {
	  in_GPR_READ_VAL           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	 out_GPR_READ_ACK           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	  in_GPR_READ_OOO_ENGINE_ID [i]= new sc_signal<Tcontext_t        > (rename.c_str());
	  in_GPR_READ_NUM_REG       [i]= new sc_signal<Tgeneral_address_t> (rename.c_str());
	 out_GPR_READ_DATA          [i]= new sc_signal<Tgeneral_data_t   > (rename.c_str());
	 out_GPR_READ_DATA_VAL      [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
       }

    // ~~~~~[Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      in_GPR_WRITE_VAL                 = new sc_signal<Tcontrol_t        > * [_param->_nb_gpr_write];
     out_GPR_WRITE_ACK                 = new sc_signal<Tcontrol_t        > * [_param->_nb_gpr_write];
      in_GPR_WRITE_OOO_ENGINE_ID       = new sc_signal<Tcontext_t        > * [_param->_nb_gpr_write];
      in_GPR_WRITE_NUM_REG             = new sc_signal<Tgeneral_address_t> * [_param->_nb_gpr_write];
      in_GPR_WRITE_DATA                = new sc_signal<Tgeneral_data_t   > * [_param->_nb_gpr_write];
     
     for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
       {
	  in_GPR_WRITE_VAL           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	 out_GPR_WRITE_ACK           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	  in_GPR_WRITE_OOO_ENGINE_ID [i]= new sc_signal<Tcontext_t        > (rename.c_str());
	  in_GPR_WRITE_NUM_REG       [i]= new sc_signal<Tgeneral_address_t> (rename.c_str());
	  in_GPR_WRITE_DATA          [i]= new sc_signal<Tgeneral_data_t   > (rename.c_str());
       }

    // ~~~~~[Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      in_SPR_READ_VAL                 = new sc_signal<Tcontrol_t        > * [_param->_nb_spr_read];
     out_SPR_READ_ACK                 = new sc_signal<Tcontrol_t        > * [_param->_nb_spr_read];
      in_SPR_READ_OOO_ENGINE_ID       = new sc_signal<Tcontext_t        > * [_param->_nb_spr_read];
      in_SPR_READ_NUM_REG             = new sc_signal<Tspecial_address_t> * [_param->_nb_spr_read];
     out_SPR_READ_DATA                = new sc_signal<Tspecial_data_t   > * [_param->_nb_spr_read];
     out_SPR_READ_DATA_VAL            = new sc_signal<Tcontrol_t        > * [_param->_nb_spr_read];
     
     for (uint32_t i=0; i<_param->_nb_spr_read; i++)
       {
          in_SPR_READ_VAL           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	 out_SPR_READ_ACK           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	  in_SPR_READ_OOO_ENGINE_ID [i]= new sc_signal<Tcontext_t        > (rename.c_str());
	  in_SPR_READ_NUM_REG       [i]= new sc_signal<Tspecial_address_t> (rename.c_str());
	 out_SPR_READ_DATA          [i]= new sc_signal<Tspecial_data_t   > (rename.c_str());
	 out_SPR_READ_DATA_VAL      [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
       }

    // ~~~~~[Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      in_SPR_WRITE_VAL                 = new sc_signal<Tcontrol_t        > * [_param->_nb_spr_write];
     out_SPR_WRITE_ACK                 = new sc_signal<Tcontrol_t        > * [_param->_nb_spr_write];
      in_SPR_WRITE_OOO_ENGINE_ID       = new sc_signal<Tcontext_t        > * [_param->_nb_spr_write];
      in_SPR_WRITE_NUM_REG             = new sc_signal<Tspecial_address_t> * [_param->_nb_spr_write];
      in_SPR_WRITE_DATA                = new sc_signal<Tspecial_data_t   > * [_param->_nb_spr_write];
     
     for (uint32_t i=0; i<_param->_nb_spr_write; i++)
       {
          in_SPR_WRITE_VAL           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
         out_SPR_WRITE_ACK           [i]= new sc_signal<Tcontrol_t        > (rename.c_str());
	  in_SPR_WRITE_OOO_ENGINE_ID [i]= new sc_signal<Tcontext_t        > (rename.c_str());
	  in_SPR_WRITE_NUM_REG       [i]= new sc_signal<Tspecial_address_t> (rename.c_str());
	  in_SPR_WRITE_DATA          [i]= new sc_signal<Tspecial_data_t   > (rename.c_str());
       }

    // ~~~~~[Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      in_INSERT_ROB_VAL        = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
     out_INSERT_ROB_ACK        = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_INSERT_ROB_RD_USE     = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_INSERT_ROB_RD_NUM_REG = new sc_signal<Tgeneral_address_t> ** [_param->_nb_ooo_engine];
      in_INSERT_ROB_RE_USE     = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_INSERT_ROB_RE_NUM_REG = new sc_signal<Tspecial_address_t> ** [_param->_nb_ooo_engine];

     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
       {
	 uint32_t x=_param->_nb_inst_insert_rob [i];

	  in_INSERT_ROB_VAL        [i] = new sc_signal<Tcontrol_t        > * [x];
	 out_INSERT_ROB_ACK        [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_INSERT_ROB_RD_USE     [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_INSERT_ROB_RD_NUM_REG [i] = new sc_signal<Tgeneral_address_t> * [x];
	  in_INSERT_ROB_RE_USE     [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_INSERT_ROB_RE_NUM_REG [i] = new sc_signal<Tspecial_address_t> * [x];

	 for (uint32_t j=0; j<x; j++)
	   {
	      in_INSERT_ROB_VAL        [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	     out_INSERT_ROB_ACK        [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_INSERT_ROB_RD_USE     [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_INSERT_ROB_RD_NUM_REG [i][j] = new sc_signal<Tgeneral_address_t> (rename.c_str());
	      in_INSERT_ROB_RE_USE     [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_INSERT_ROB_RE_NUM_REG [i][j] = new sc_signal<Tspecial_address_t> (rename.c_str());
	     
	   }
       }

    // ~~~~~[Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      in_RETIRE_ROB_VAL            = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
     out_RETIRE_ROB_ACK            = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RD_OLD_USE     = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RD_OLD_NUM_REG = new sc_signal<Tgeneral_address_t> ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RE_OLD_USE     = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RE_OLD_NUM_REG = new sc_signal<Tspecial_address_t> ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RD_NEW_USE     = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RD_NEW_NUM_REG = new sc_signal<Tgeneral_address_t> ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RE_NEW_USE     = new sc_signal<Tcontrol_t        > ** [_param->_nb_ooo_engine];
      in_RETIRE_ROB_RE_NEW_NUM_REG = new sc_signal<Tspecial_address_t> ** [_param->_nb_ooo_engine];

     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
       {
	 uint32_t x=_param->_nb_inst_retire_rob [i];

	  in_RETIRE_ROB_VAL            [i] = new sc_signal<Tcontrol_t        > * [x];
	 out_RETIRE_ROB_ACK            [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_RETIRE_ROB_RD_OLD_USE     [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_RETIRE_ROB_RD_OLD_NUM_REG [i] = new sc_signal<Tgeneral_address_t> * [x];
	  in_RETIRE_ROB_RE_OLD_USE     [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_RETIRE_ROB_RE_OLD_NUM_REG [i] = new sc_signal<Tspecial_address_t> * [x];
	  in_RETIRE_ROB_RD_NEW_USE     [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_RETIRE_ROB_RD_NEW_NUM_REG [i] = new sc_signal<Tgeneral_address_t> * [x];
	  in_RETIRE_ROB_RE_NEW_USE     [i] = new sc_signal<Tcontrol_t        > * [x];
	  in_RETIRE_ROB_RE_NEW_NUM_REG [i] = new sc_signal<Tspecial_address_t> * [x];

	 for (uint32_t j=0; j<x; j++)
	   {
	      in_RETIRE_ROB_VAL            [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	     out_RETIRE_ROB_ACK            [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_RETIRE_ROB_RD_OLD_USE     [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_RETIRE_ROB_RD_OLD_NUM_REG [i][j] = new sc_signal<Tgeneral_address_t> (rename.c_str());
	      in_RETIRE_ROB_RE_OLD_USE     [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_RETIRE_ROB_RE_OLD_NUM_REG [i][j] = new sc_signal<Tspecial_address_t> (rename.c_str());
	      in_RETIRE_ROB_RD_NEW_USE     [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_RETIRE_ROB_RD_NEW_NUM_REG [i][j] = new sc_signal<Tgeneral_address_t> (rename.c_str());
	      in_RETIRE_ROB_RE_NEW_USE     [i][j] = new sc_signal<Tcontrol_t        > (rename.c_str());
	      in_RETIRE_ROB_RE_NEW_NUM_REG [i][j] = new sc_signal<Tspecial_address_t> (rename.c_str());
	   }
       }

  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Register_unit" << endl;
  
  (*(_Register_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Register_unit->in_NRESET))       (*(in_NRESET));
  
  for (uint32_t i=0; i<_param->_nb_gpr_read; i++)
    {
      (*(_Register_unit-> in_GPR_READ_VAL           [i]))(*( in_GPR_READ_VAL           [i]));
      (*(_Register_unit->out_GPR_READ_ACK           [i]))(*(out_GPR_READ_ACK           [i]));
      if (_param->_have_port_ooo_engine_id == true)
	(*(_Register_unit-> in_GPR_READ_OOO_ENGINE_ID [i]))(*( in_GPR_READ_OOO_ENGINE_ID [i]));
      (*(_Register_unit-> in_GPR_READ_NUM_REG       [i]))(*( in_GPR_READ_NUM_REG       [i]));
      (*(_Register_unit->out_GPR_READ_DATA          [i]))(*(out_GPR_READ_DATA          [i]));
      (*(_Register_unit->out_GPR_READ_DATA_VAL      [i]))(*(out_GPR_READ_DATA_VAL      [i]));
    }
  for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
    {
      (*(_Register_unit-> in_GPR_WRITE_VAL           [i]))(*( in_GPR_WRITE_VAL           [i]));
      (*(_Register_unit->out_GPR_WRITE_ACK           [i]))(*(out_GPR_WRITE_ACK           [i]));
      if (_param->_have_port_ooo_engine_id == true)
	(*(_Register_unit-> in_GPR_WRITE_OOO_ENGINE_ID [i]))(*( in_GPR_WRITE_OOO_ENGINE_ID [i]));
      (*(_Register_unit-> in_GPR_WRITE_NUM_REG       [i]))(*( in_GPR_WRITE_NUM_REG       [i]));
      (*(_Register_unit-> in_GPR_WRITE_DATA          [i]))(*( in_GPR_WRITE_DATA          [i]));
    }
  for (uint32_t i=0; i<_param->_nb_spr_read; i++)
    {
      (*(_Register_unit-> in_SPR_READ_VAL           [i]))(*( in_SPR_READ_VAL           [i]));
      (*(_Register_unit->out_SPR_READ_ACK           [i]))(*(out_SPR_READ_ACK           [i]));
      if (_param->_have_port_ooo_engine_id == true)
	(*(_Register_unit-> in_SPR_READ_OOO_ENGINE_ID [i]))(*( in_SPR_READ_OOO_ENGINE_ID [i]));
      (*(_Register_unit-> in_SPR_READ_NUM_REG       [i]))(*( in_SPR_READ_NUM_REG       [i]));
      (*(_Register_unit->out_SPR_READ_DATA          [i]))(*(out_SPR_READ_DATA          [i]));
      (*(_Register_unit->out_SPR_READ_DATA_VAL      [i]))(*(out_SPR_READ_DATA_VAL      [i]));
    }
  for (uint32_t i=0; i<_param->_nb_spr_write; i++)
    {
      (*(_Register_unit-> in_SPR_WRITE_VAL           [i]))(*( in_SPR_WRITE_VAL           [i]));
      (*(_Register_unit->out_SPR_WRITE_ACK           [i]))(*(out_SPR_WRITE_ACK           [i]));
      if (_param->_have_port_ooo_engine_id == true)
	(*(_Register_unit-> in_SPR_WRITE_OOO_ENGINE_ID [i]))(*( in_SPR_WRITE_OOO_ENGINE_ID [i]));
      (*(_Register_unit-> in_SPR_WRITE_NUM_REG       [i]))(*( in_SPR_WRITE_NUM_REG       [i]));
      (*(_Register_unit-> in_SPR_WRITE_DATA          [i]))(*( in_SPR_WRITE_DATA          [i]));
    }
  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
    for (uint32_t j=0; j<_param->_nb_inst_insert_rob [i]; j++)
      {
	(*(_Register_unit-> in_INSERT_ROB_VAL        [i][j]))(*( in_INSERT_ROB_VAL        [i][j]));
	(*(_Register_unit->out_INSERT_ROB_ACK        [i][j]))(*(out_INSERT_ROB_ACK        [i][j]));
	(*(_Register_unit-> in_INSERT_ROB_RD_USE     [i][j]))(*( in_INSERT_ROB_RD_USE     [i][j]));
	(*(_Register_unit-> in_INSERT_ROB_RD_NUM_REG [i][j]))(*( in_INSERT_ROB_RD_NUM_REG [i][j]));
	(*(_Register_unit-> in_INSERT_ROB_RE_USE     [i][j]))(*( in_INSERT_ROB_RE_USE     [i][j]));
	(*(_Register_unit-> in_INSERT_ROB_RE_NUM_REG [i][j]))(*( in_INSERT_ROB_RE_NUM_REG [i][j]));
      }
  for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
    for (uint32_t j=0; j<_param->_nb_inst_retire_rob [i]; j++)
      {
	(*(_Register_unit-> in_RETIRE_ROB_VAL            [i][j]))(*( in_RETIRE_ROB_VAL            [i][j]));
	(*(_Register_unit->out_RETIRE_ROB_ACK            [i][j]))(*(out_RETIRE_ROB_ACK            [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RD_OLD_USE     [i][j]))(*( in_RETIRE_ROB_RD_OLD_USE     [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RD_OLD_NUM_REG [i][j]))(*( in_RETIRE_ROB_RD_OLD_NUM_REG [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RE_OLD_USE     [i][j]))(*( in_RETIRE_ROB_RE_OLD_USE     [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RE_OLD_NUM_REG [i][j]))(*( in_RETIRE_ROB_RE_OLD_NUM_REG [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RD_NEW_USE     [i][j]))(*( in_RETIRE_ROB_RD_NEW_USE     [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RD_NEW_NUM_REG [i][j]))(*( in_RETIRE_ROB_RD_NEW_NUM_REG [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RE_NEW_USE     [i][j]))(*( in_RETIRE_ROB_RE_NEW_USE     [i][j]));
	(*(_Register_unit-> in_RETIRE_ROB_RE_NEW_NUM_REG [i][j]))(*( in_RETIRE_ROB_RE_NEW_NUM_REG [i][j]));
      }
  
  cout << "<" << name << "> Start Simulation ............" << endl;
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);

  LABEL("Initialisation");

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration "+toString(iteration));

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;
  cout << "<" << name << "> ............ Stop Simulation" << endl;

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_GPR_READ_VAL                 ;
  delete [] out_GPR_READ_ACK                 ;
  delete []  in_GPR_READ_OOO_ENGINE_ID       ;
  delete []  in_GPR_READ_NUM_REG             ;
  delete [] out_GPR_READ_DATA                ;
  delete [] out_GPR_READ_DATA_VAL            ;
  delete []  in_GPR_WRITE_VAL                ;
  delete [] out_GPR_WRITE_ACK                ;
  delete []  in_GPR_WRITE_OOO_ENGINE_ID      ;
  delete []  in_GPR_WRITE_NUM_REG            ;
  delete []  in_GPR_WRITE_DATA               ;
  delete []  in_SPR_READ_VAL                 ;
  delete [] out_SPR_READ_ACK                 ;
  delete []  in_SPR_READ_OOO_ENGINE_ID       ;
  delete []  in_SPR_READ_NUM_REG             ;
  delete [] out_SPR_READ_DATA                ;
  delete [] out_SPR_READ_DATA_VAL            ;
  delete []  in_SPR_WRITE_VAL                ;
  delete [] out_SPR_WRITE_ACK                ;
  delete []  in_SPR_WRITE_OOO_ENGINE_ID      ;
  delete []  in_SPR_WRITE_NUM_REG            ;
  delete []  in_SPR_WRITE_DATA               ;
  delete []  in_INSERT_ROB_VAL               ;
  delete [] out_INSERT_ROB_ACK               ;
  delete []  in_INSERT_ROB_RD_USE            ;
  delete []  in_INSERT_ROB_RD_NUM_REG        ;
  delete []  in_INSERT_ROB_RE_USE            ;
  delete []  in_INSERT_ROB_RE_NUM_REG        ;
  delete []  in_RETIRE_ROB_VAL               ;
  delete [] out_RETIRE_ROB_ACK               ;
  delete []  in_RETIRE_ROB_RD_OLD_USE        ;
  delete []  in_RETIRE_ROB_RD_OLD_NUM_REG    ;
  delete []  in_RETIRE_ROB_RD_NEW_USE        ;
  delete []  in_RETIRE_ROB_RD_NEW_NUM_REG    ;
  delete []  in_RETIRE_ROB_RE_OLD_USE        ; 
  delete []  in_RETIRE_ROB_RE_OLD_NUM_REG    ;
  delete []  in_RETIRE_ROB_RE_NEW_USE        ;
  delete []  in_RETIRE_ROB_RE_NEW_NUM_REG    ;
#endif

  delete _Register_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
