#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_reservation_station_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_read_unit_read_unit_reservation_station_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _size_queue           ;
  public : const uint32_t    _nb_context           ;
  public : const uint32_t    _nb_packet            ;
  public : const uint32_t    _size_general_data    ;
  public : const uint32_t    _size_special_data    ;
  public : const uint32_t    _nb_general_register  ;
  public : const uint32_t    _nb_special_register  ;
  public : const uint32_t    _nb_operation         ;
  public : const uint32_t    _nb_type              ;
  public : const uint32_t    _nb_gpr_write         ;
  public : const uint32_t    _nb_spr_write         ;
  public : const uint32_t    _nb_bypass_write      ;//if nb_bypass=0, then bypass is desactivated
  public : const uint32_t    _nb_bypass_memory     ;//if nb_bypass=0, then bypass is desactivated
    /*
  public : const bool        _have_immediat        ;
  public : const bool        _have_gpr_ra          ;
  public : const bool        _have_gpr_rb          ;
  public : const bool        _have_spr_rc          ;
  public : const bool        _have_gpr_rd          ;
  public : const bool        _have_spr_re          ;
    */
  public : const uint32_t    _size_context_id      ;
  public : const uint32_t    _size_packet_id       ;
  public : const uint32_t    _size_general_register;
  public : const uint32_t    _size_special_register;
  public : const uint32_t    _size_operation       ;
  public : const uint32_t    _size_type            ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t size_queue         ,
			uint32_t nb_context         ,
			uint32_t nb_packet          ,
			uint32_t size_general_data  ,
			uint32_t size_special_data  ,
			uint32_t nb_general_register,
			uint32_t nb_special_register,
			uint32_t nb_operation       ,
			uint32_t nb_type            ,
			uint32_t nb_gpr_write       ,
			uint32_t nb_spr_write       ,
			uint32_t nb_bypass_write    ,
			uint32_t nb_bypass_memory   );

  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Parameters & x);
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
