#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Load_store_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_load_store_unit_Load_store_unit_h

/*
 * $Id$
 *
 * [Description ]
 * 
 * Ce composant peut tre amlior en placant deux ptr de lecture au lieu d'un : un pour l'accs au cache et un pour le commit
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Types.h"
#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Statistics.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

using namespace std;
using namespace morpheo::behavioural::generic::queue_control;

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


  class Load_store_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string       _name;

  protected : const Parameters * _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics * _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[Interface "memory_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_MEMORY_IN_VAL         ;
  public    : SC_OUT(Tcontrol_t        )    * out_MEMORY_IN_ACK         ;
  public    : SC_IN (Tcontext_t        )    *  in_MEMORY_IN_CONTEXT_ID  ;
  public    : SC_IN (Tpacket_t         )    *  in_MEMORY_IN_PACKET_ID   ;
  public    : SC_IN (Toperation_t      )    *  in_MEMORY_IN_OPERATION   ;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_MEMORY_IN_STORE_QUEUE_PTR_WRITE;
  public    : SC_IN (Tlsq_ptr_t        )    *  in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE;
//public    : SC_IN (Tcontrol_t        )    *  in_MEMORY_IN_HAS_IMMEDIAT;
  public    : SC_IN (Tgeneral_data_t   )    *  in_MEMORY_IN_IMMEDIAT    ; // memory address
  public    : SC_IN (Tgeneral_data_t   )    *  in_MEMORY_IN_DATA_RA     ; // memory address
  public    : SC_IN (Tgeneral_data_t   )    *  in_MEMORY_IN_DATA_RB     ; // data        (store)
//public    : SC_IN (Tspecial_data_t   )    *  in_MEMORY_IN_DATA_RC     ;
  public    : SC_IN (Tcontrol_t        )    *  in_MEMORY_IN_WRITE_RD    ; // = (operation==load)
  public    : SC_IN (Tgeneral_address_t)    *  in_MEMORY_IN_NUM_REG_RD  ; // destination (load)
//public    : SC_IN (Tcontrol_t        )    *  in_MEMORY_IN_WRITE_RE    ;
//public    : SC_IN (Tspecial_address_t)    *  in_MEMORY_IN_NUM_REG_RE  ;

    // ~~~~~[Interface "memory_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )    * out_MEMORY_OUT_VAL       ;
  public    : SC_IN (Tcontrol_t        )    *  in_MEMORY_OUT_ACK       ;
  public    : SC_OUT(Tcontext_t        )    * out_MEMORY_OUT_CONTEXT_ID;
  public    : SC_OUT(Tpacket_t         )    * out_MEMORY_OUT_PACKET_ID ;
  public    : SC_OUT(Tcontrol_t        )    * out_MEMORY_OUT_WRITE_RD  ; // = (operation==load)
  public    : SC_OUT(Tgeneral_address_t)    * out_MEMORY_OUT_NUM_REG_RD; // destination (load)
  public    : SC_OUT(Tgeneral_data_t   )    * out_MEMORY_OUT_DATA_RD   ; // data        (load)
//public    : SC_OUT(Tcontrol_t        )    * out_MEMORY_OUT_WRITE_RE  ;
//public    : SC_OUT(Tspecial_address_t)    * out_MEMORY_OUT_NUM_REG_RE;
//public    : SC_OUT(Tspecial_data_t   )    * out_MEMORY_OUT_DATA_RE   ;
  public    : SC_OUT(Texception_t      )    * out_MEMORY_OUT_EXCEPTION ;

    // ~~~~~[Interface "dcache_req"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )    * out_DCACHE_REQ_VAL       ;
  public    : SC_IN (Tcontrol_t        )    *  in_DCACHE_REQ_ACK       ;
  public    : SC_OUT(Tcontext_t        )    * out_DCACHE_REQ_CONTEXT_ID;
  public    : SC_OUT(Tpacket_t         )    * out_DCACHE_REQ_PACKET_ID ;
  public    : SC_OUT(Tdcache_address_t )    * out_DCACHE_REQ_ADDRESS   ;
  public    : SC_OUT(Tdcache_type_t    )    * out_DCACHE_REQ_TYPE      ;
  public    : SC_OUT(Tcontrol_t        )    * out_DCACHE_REQ_UNCACHED  ;
  public    : SC_OUT(Tdcache_data_t    )    * out_DCACHE_REQ_WDATA     ;

    // ~~~~~[Interface "dcache_rsp"]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_DCACHE_RSP_VAL       ;
  public    : SC_OUT(Tcontrol_t        )    * out_DCACHE_RSP_ACK       ;
  public    : SC_IN (Tcontext_t        )    *  in_DCACHE_RSP_CONTEXT_ID;
  public    : SC_IN (Tpacket_t         )    *  in_DCACHE_RSP_PACKET_ID ;
  public    : SC_IN (Tdcache_data_t    )    *  in_DCACHE_RSP_RDATA     ;
  public    : SC_IN (Tdcache_error_t   )    *  in_DCACHE_RSP_ERROR     ;

    // ~~~~~[Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_BYPASS_MEMORY_VAL       ;
  public    : SC_OUT(Tcontext_t        )   ** out_BYPASS_MEMORY_CONTEXT_ID;
  public    : SC_OUT(Tgeneral_address_t)   ** out_BYPASS_MEMORY_NUM_REG   ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_BYPASS_MEMORY_DATA      ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : Tstore_queue_entry_t                                        * _store_queue;
  protected : Tload_queue_entry_t                                         * _load_queue;
  protected : Tspeculative_access_queue_entry_t                           * _speculative_access_queue;
  protected : morpheo::behavioural::generic::queue_control::Queue_Control * _speculative_access_queue_control;

    // function pointer
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_transition     ) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMoore       ) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMealy_dcache) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMealy_insert) (void);
  public    : void (morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Load_store_unit::*function_genMealy_retire) (void);

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // Registers
  public    : Tlsq_ptr_t                      internal_MEMORY_STORE_QUEUE_PTR_READ;
  public    : Tlsq_ptr_t                      internal_MEMORY_LOAD_QUEUE_PTR_READ ;

    // signal
  private   : Tcontrol_t                      internal_MEMORY_IN_ACK;
  private   : Tcontrol_t                      internal_MEMORY_OUT_VAL;
  private   : Tselect_queue_t                 internal_MEMORY_OUT_SELECT_QUEUE;

  private   : Tcontrol_t                      internal_DCACHE_REQ_VAL;
  private   : Tselect_queue_t                 internal_DCACHE_REQ_SELECT_QUEUE;
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Load_store_unit);
#endif
  public  :          Load_store_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   string                                        name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param );
  public  :          ~Load_store_unit             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);

  public  : void     transition                (void);
  public  : void     genMoore                  (void);
  public  : void     genMealy_dcache           (void);
  public  : void     genMealy_insert           (void);
  public  : void     genMealy_retire           (void);
   
  public  : void     function_speculative_load_commit_transition      (void);
  public  : void     function_speculative_load_commit_genMoore        (void);
  public  : void     function_speculative_load_commit_genMealy_dcache (void);
  public  : void     function_speculative_load_commit_genMealy_insert (void);
  public  : void     function_speculative_load_commit_genMealy_retire (void);
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
