#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {

#undef  FUNCTION
#define FUNCTION "Read_queue::genMoore"
  void Read_queue::genMoore (void)
  {
    log_printf(FUNC,Read_queue,FUNCTION,"Begin");

    bool not_full  = not (_queue->size() == _param->_size_queue);
    bool not_empty = not _queue->empty();

    // ~~~~~[Interface "read_queue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    PORT_WRITE (out_READ_QUEUE_IN_ACK , not_full );

    // ~~~~~[Interface "read_queue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  PORT_WRITE (out_READ_QUEUE_OUT_VAL         , not_empty    );              // in genMealy_val

    PORT_WRITE (out_READ_QUEUE_OUT_CONTEXT_ID  , _queue_head->_context_id  );
    PORT_WRITE (out_READ_QUEUE_OUT_PACKET_ID   , _queue_head->_packet_id   );
    PORT_WRITE (out_READ_QUEUE_OUT_OPERATION   , _queue_head->_operation   );
    PORT_WRITE (out_READ_QUEUE_OUT_TYPE        , _queue_head->_type        );
    PORT_WRITE (out_READ_QUEUE_OUT_HAS_IMMEDIAT, _queue_head->_has_immediat);
    PORT_WRITE (out_READ_QUEUE_OUT_IMMEDIAT    , _queue_head->_immediat    );
    PORT_WRITE (out_READ_QUEUE_OUT_READ_RA     , _queue_head->_read_ra     );
    PORT_WRITE (out_READ_QUEUE_OUT_NUM_REG_RA  , _queue_head->_num_reg_ra  );
//  PORT_WRITE (out_READ_QUEUE_OUT_DATA_RA_VAL , _queue_head->_data_ra_val ); // in genMealy_gpr
//  PORT_WRITE (out_READ_QUEUE_OUT_DATA_RA     , _queue_head->_data_ra     ); // in genMealy_gpr
    PORT_WRITE (out_READ_QUEUE_OUT_READ_RB     , _queue_head->_read_rb     );
    PORT_WRITE (out_READ_QUEUE_OUT_NUM_REG_RB  , _queue_head->_num_reg_rb  );
//  PORT_WRITE (out_READ_QUEUE_OUT_DATA_RB_VAL , _queue_head->_data_rb_val ); // in genMealy_gpr
//  PORT_WRITE (out_READ_QUEUE_OUT_DATA_RB     , _queue_head->_data_rb     ); // in genMealy_gpr
    PORT_WRITE (out_READ_QUEUE_OUT_READ_RC     , _queue_head->_read_rc     );
    PORT_WRITE (out_READ_QUEUE_OUT_NUM_REG_RC  , _queue_head->_num_reg_rc  );
//  PORT_WRITE (out_READ_QUEUE_OUT_DATA_RC_VAL , _queue_head->_data_rc_val ); // in genMealy_spr
//  PORT_WRITE (out_READ_QUEUE_OUT_DATA_RC     , _queue_head->_data_rc     ); // in genMealy_spr
    PORT_WRITE (out_READ_QUEUE_OUT_WRITE_RD    , _queue_head->_write_rd    );
    PORT_WRITE (out_READ_QUEUE_OUT_NUM_REG_RD  , _queue_head->_num_reg_rd  );
    PORT_WRITE (out_READ_QUEUE_OUT_WRITE_RE    , _queue_head->_write_re    );
    PORT_WRITE (out_READ_QUEUE_OUT_NUM_REG_RE  , _queue_head->_num_reg_re  );

    // ~~~~~[Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    PORT_WRITE (out_GPR_READ_VAL        [0], not_empty and _queue_head->_read_ra_val);
    PORT_WRITE (out_GPR_READ_VAL        [1], not_empty and _queue_head->_read_rb_val);
    PORT_WRITE (out_GPR_READ_CONTEXT_ID [0],               _queue_head->_context_id);
    PORT_WRITE (out_GPR_READ_CONTEXT_ID [1],               _queue_head->_context_id);
    PORT_WRITE (out_GPR_READ_NUM_REG    [0],               _queue_head->_num_reg_ra);
    PORT_WRITE (out_GPR_READ_NUM_REG    [1],               _queue_head->_num_reg_rb);

    // ~~~~~[Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    PORT_WRITE (out_SPR_READ_VAL        [0], not_empty and _queue_head->_read_rc_val);
    PORT_WRITE (out_SPR_READ_CONTEXT_ID [0],               _queue_head->_context_id);
    PORT_WRITE (out_SPR_READ_NUM_REG    [0],               _queue_head->_num_reg_rc);
		    
    log_printf(FUNC,Read_queue,FUNCTION,"End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
