/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/SelfTest/include/test.h"

#define NB_PARAMS 11

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - size_store_queue        (uint32_t)" << endl
       << " - size_load_queue         (uint32_t)" << endl
       << " - size_speculative_access_queue (uint32_t)" << endl
       << " - nb_port_check           (uint32_t)" << endl
       << " - speculative_load        (uint32_t)" << endl
       << " - nb_context              (uint32_t)" << endl
       << " - nb_packet               (uint32_t)" << endl
       << " - size_general_data       (uint32_t)" << endl
       << " - nb_general_register     (uint32_t)" << endl
       << " - nb_operation            (uint32_t)" << endl
       << " - nb_type                 (uint32_t)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  const string              name                     = argv[1];
  const uint32_t            _size_store_queue        = atoi(argv[ 2]);
  const uint32_t            _size_load_queue         = atoi(argv[ 3]);
  const uint32_t            _size_speculative_access_queue = atoi(argv[ 4]);
  const uint32_t            _nb_port_check           = atoi(argv[ 5]);
  const Tspeculative_load_t _speculative_load        = fromString<Tspeculative_load_t>(argv[ 6]);
  const uint32_t            _nb_context              = atoi(argv[ 7]);
  const uint32_t            _nb_packet               = atoi(argv[ 8]);
  const uint32_t            _size_general_data       = atoi(argv[ 9]);
  const uint32_t            _nb_general_register     = atoi(argv[10]);
  const uint32_t            _nb_operation            = atoi(argv[11]);
  const uint32_t            _nb_type                 = atoi(argv[12]);

  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters
	(
	 _size_store_queue       ,
	 _size_load_queue        ,
	 _size_speculative_access_queue,
	 _nb_port_check          ,
	 _speculative_load       ,
	 _nb_context             ,
	 _nb_packet              ,
	 _size_general_data      ,
	 _nb_general_register    ,
	 _nb_operation           ,
	 _nb_type                
        );
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

