#ifndef morpheo_tostring
#define morpheo_tostring

/*
 * $Id$
 *
 * with a stephane dubuisson initial idea
 *
 * [ Description ]
 * 
 */

#include <iosfwd>
#include <sstream>
#include <iomanip>
#include <string>
#include <limits>

using std::setprecision ; 
using std::ostringstream ; 
using std::boolalpha ;

namespace morpheo              {
  
  template<typename T> inline std::string toString             (const T& x)
  {
    ostringstream out("");
    out << x;
    return out.str();
  }
  
  template<>           inline std::string toString<bool>       (const bool& x)
  {
    ostringstream out("");
    //out << boolalpha << x;
    out << x;
    return out.str();
  }
  
  template<>           inline std::string toString<float>      (const float& x)
  {
    const int sigdigits = std::numeric_limits<float>::digits10;
    ostringstream out("");
    out << setprecision(sigdigits) << x;
    return out.str();
  }
  
  template<>           inline std::string toString<double>     (const double& x)
  {
    const int sigdigits = std::numeric_limits<double>::digits10;
    ostringstream out("");
    out << setprecision(sigdigits) << x;
    return out.str();
  }
  
  template<>           inline std::string toString<long double>(const long double& x)
  {
    const int sigdigits = std::numeric_limits<long double>::digits10;
    ostringstream out("");
    out << setprecision(sigdigits) << x;
    return out.str();
  }

//   template<>           inline std::string toString< int8_t>       (const int8_t& x)
//   {
//     ostringstream out("");
//     out << x;
//     return out.str();
//   }

//   template<>           inline std::string toString<uint8_t>       (const uint8_t& x)
//   {
//     ostringstream out("");
//     out << x;
//     return out.str();
//   }

//   template<>           inline std::string toString< int16_t>      (const int16_t& x)
//   {
//     ostringstream out("");
//     out << x;
//     return out.str();
//   }

//   template<>           inline std::string toString<uint16_t>      (const uint16_t& x)
//   {
//     ostringstream out("");
//     out << x;
//     return out.str();
//   }

//   template<>           inline std::string toString< int32_t>      (const int32_t& x)
//   {
//     ostringstream out("");
//     out << x;
//     return out.str();
//   }

//   template<>           inline std::string toString<uint32_t>      (const uint32_t& x)
//   {
//     ostringstream out("");
//     out << x;
//     return out.str();
//   }
  
}; // end namespace morpheo              

#endif
