/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::Queue"
  Queue::Queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

    log_printf(INFO,Queue,FUNCTION,"Allocation");
    allocation ();

#ifdef STATISTICS
    log_printf(INFO,Queue,FUNCTION,"Allocation of statistics");

    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(INFO,Queue,FUNCTION,"Generate the vhdl");

    vhdl();
#endif

#ifdef SYSTEMC
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    log_printf(INFO,Queue,FUNCTION,"Method - transition");

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();
//#endif

# ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
# endif    

    log_printf(INFO,Queue,FUNCTION,"Method - genMoore");

    SC_METHOD (genMoore);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg();

# ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
# endif    

#endif
    log_printf(FUNC,Queue,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Queue::~Queue"
  Queue::~Queue (void)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");

#ifdef STATISTICS
    log_printf(INFO,Queue,FUNCTION,"Generate Statistics file");

    _stat->generate_file(statistics(0));
    delete _stat;
#endif

    log_printf(INFO,Queue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
