#ifndef WRITE_BUFFER_H
#define WRITE_BUFFER_H

#include "address.h"
#include <iostream>
using namespace std;

namespace hierarchy_memory          {
namespace cache                     {
namespace cache_multilevel          {
namespace cache_onelevel            {

  class write_buffer_t
    {
    public    : address_t       address;
    public    : uint32_t        trdid;

    public    : write_buffer_t ()
      {
      }

    public    : write_buffer_t (address_t address, uint32_t trdid)
      {
	this->address = address;
	this->trdid   = trdid;
      }

      friend ostream& operator<< (ostream& output_stream, const write_buffer_t &x)
      {
	output_stream << x.address           << " "
		      << x.trdid;

	return output_stream;
      }

    };

};};};};

#endif //!WRITE_BUFFER_H
