/********************************************
 * files               : asm_001_add.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                : Addition
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.bf
 *                         l.jal
 *                         l.jr
 *                         l.lwz
 *                         l.movhi
 *                         l.ori
 *                         l.sfne
 *                         l.sw
 ********************************************
 */
	.file	"asm_001_add.s"
	.section .text
	.align	4

	.global _asm_001_add
_asm_001_add :
	/* save context */
	l.addi	r1,r1,-8
	l.sw	 0(r1),r20
	l.sw	 4(r1),r21
		
	/* Return is KO (default)*/
	l.and   r11,r0,r0

	l.add	r20,r0,r0	/* e + e = e */
	
	l.sfne	r20,r0
	l.bf	_asm_001_add_ko
	l.addi	r20,r0,1

	l.addi	r21,r0,-1
	l.add	r21,r21,r20	/* -1 + 1 */

	l.sfne	r21,r0
	l.bf	_asm_001_add_ko
	l.movhi	r20,0xdead
	l.ori  	r20,r0,0xbeaf

	l.add	r21,r20,r0	/* X + e = X */
	l.sfne	r21,r20
	l.bf	_asm_001_add_ko
	l.nop	0	

	l.add	r21,r0,r20	/* e + X = X */
	l.sfne	r21,r20
	l.bf	_asm_001_add_ko
	l.nop	0	
		
_asm_001_add_ok :	
	l.addi	r11,r0,1
_asm_001_add_ko :
	
	/* load context */
	l.lwz	r21, 4(r1)
	l.lwz	r20, 0(r1)
		
	l.jr	r9
	l.addi	r1,r1,8
