/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/SelfTest/include/test.h"

#define NB_PARAMS 6

void usage (string exec)
{
  cerr << "<Usage> " << exec << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - size_data   (unsigned int)" << endl
       << " - nb_port     (unsigned int)" << endl
       << " - shift_value (unsigned int)" << endl
       << " - rotate      (unsigned int)" << endl
       << " - direction   (unsigned int)" << endl
       << " - carry       (unsigned int)" << endl;
  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != 2+NB_PARAMS)
    usage (argv[0]);

  const string                                              name        = argv[1];
  const uint32_t                                            size_data   = atoi(argv[2]);
  const uint32_t                                            nb_port     = atoi(argv[3]);
  const uint32_t                                            shift_value = atoi(argv[4]);
  const morpheo::behavioural::generic::shifter::rotate_t    rotate      = static_cast<morpheo::behavioural::generic::shifter::rotate_t   >(atoi(argv[5]));
  const morpheo::behavioural::generic::shifter::direction_t direction   = static_cast<morpheo::behavioural::generic::shifter::direction_t>(atoi(argv[6]));
  const morpheo::behavioural::generic::shifter::carry_t     carry       = static_cast<morpheo::behavioural::generic::shifter::carry_t    >(atoi(argv[7]));

  morpheo::behavioural::generic::shifter::Parameters param (size_data  ,
							    nb_port    ,
							    shift_value,
							    rotate     ,
							    direction  ,
							    carry      );

  test (name,param);

  return (EXIT_SUCCESS);
}
