#ifndef morpheo_behavioural_@DEFINE_@COMPONENT_h
#define morpheo_behavioural_@DEFINE_@COMPONENT_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/@DIRECTORY/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/@DIRECTORY/include/Statistics.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

using namespace std;

namespace morpheo {
namespace behavioural {

@NAMESPACE_BEGIN

  class @COMPONENT 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string       _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics * _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (@COMPONENT);
#endif
  public  :          @COMPONENT              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   string                                        name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~@COMPONENT             (void);
					       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                (void);
//#endif
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
  private : void     end_cycle                 (void);
  };

@NAMESPACE_END
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
