#ifndef morpheo_behavioural_generic_queue_Queue_h
#define morpheo_behavioural_generic_queue_Queue_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Queue_Control/include/Queue_Control.h"

#include "Behavioural/Generic/Queue/include/Types.h"
#include "Behavioural/Generic/Queue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/Generic/Queue/include/Statistics.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

using namespace std;
using namespace morpheo::behavioural::generic::queue_control;

namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue {


  class Queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const string       _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics * _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)            *  in_INSERT_VAL;
  public    : SC_OUT(Tcontrol_t)            * out_INSERT_ACK;
  public    : SC_IN (Tdata_t   )            *  in_INSERT_DATA;

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t)            * out_RETIRE_VAL;
  public    : SC_IN (Tcontrol_t)            *  in_RETIRE_ACK;
  public    : SC_OUT(Tdata_t   )            * out_RETIRE_DATA;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : morpheo::behavioural::generic::queue_control::Queue_Control * _queue_control;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : Tdata_t                       * _queue_data;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  protected : Tcontrol_t                      internal_INSERT_ACK;
  protected : Tcontrol_t                      internal_RETIRE_VAL;

#endif

    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Queue);
#endif
  public  :          Queue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   string                                        name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Queue             (void);
					       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
