#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  void Read_queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Read_queue,"vhdl_declaration","Begin");


    vhdl->set_signal ("internal_READ_QUEUE_OUT_VAL   ",1);

    vhdl->set_signal ("reg_NEED_NEW_HEAD             ",1);
    vhdl->set_signal ("reg_READ_RA_VAL               ",1);
    vhdl->set_signal ("reg_READ_RB_VAL               ",1);
    vhdl->set_signal ("reg_READ_RC_VAL               ",1);
    vhdl->set_signal ("reg_DATA_RA_VAL               ",1);
    vhdl->set_signal ("reg_DATA_RB_VAL               ",1);
    vhdl->set_signal ("reg_DATA_RA                   ",_param->_size_general_data);
    vhdl->set_signal ("reg_DATA_RB                   ",_param->_size_general_data);
    vhdl->set_signal ("reg_DATA_RC_VAL               ",1);
    vhdl->set_signal ("reg_DATA_RC                   ",_param->_size_special_data);

    vhdl->set_signal ("internal_NEXT_NEED_NEW_HEAD   ",1);
    vhdl->set_signal ("internal_NEXT_READ_RA_VAL     ",1);
    vhdl->set_signal ("internal_NEXT_READ_RB_VAL     ",1);
    vhdl->set_signal ("internal_NEXT_READ_RC_VAL     ",1);
    vhdl->set_signal ("internal_NEXT_DATA_RA_VAL     ",1);
    vhdl->set_signal ("internal_NEXT_DATA_RB_VAL     ",1);
    vhdl->set_signal ("internal_NEXT_DATA_RA         ",_param->_size_general_data);
    vhdl->set_signal ("internal_NEXT_DATA_RB         ",_param->_size_general_data);
    vhdl->set_signal ("internal_NEXT_DATA_RC_VAL     ",1);
    vhdl->set_signal ("internal_NEXT_DATA_RC         ",_param->_size_special_data);

    vhdl->set_signal ("internal_READ_RA_VAL          ",1);
    vhdl->set_signal ("internal_READ_RB_VAL          ",1);
    vhdl->set_signal ("internal_READ_RC_VAL          ",1);
    vhdl->set_signal ("internal_DATA_RA_VAL          ",1);
    vhdl->set_signal ("internal_DATA_RB_VAL          ",1);
    vhdl->set_signal ("internal_DATA_RC_VAL          ",1);
 

    vhdl->set_alias  ("internal_QUEUE_INSERT_VAL     ",std_logic(1)," in_READ_QUEUE_IN_VAL",std_logic_range(1));
    vhdl->set_alias  ("internal_QUEUE_INSERT_ACK     ",std_logic(1),"out_READ_QUEUE_IN_ACK",std_logic_range(1));
    vhdl->set_signal ("internal_QUEUE_INSERT_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("internal_QUEUE_RETIRE_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("internal_QUEUE_RETIRE_VAL     ",1);
    vhdl->set_signal ("internal_QUEUE_RETIRE_ACK     ",1);
    
    uint32_t min = 0;
    uint32_t max, size;
    
    if(_param->_have_port_context_id   )
      {
	size = _param->_size_context_id;
	max = min-1+size;
	vhdl->set_alias ("internal_CONTEXT_ID           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	min = max+1;
      }
    if(_param->_have_port_front_end_id   )
      {
	size = _param->_size_front_end_id;
	max = min-1+size;
	vhdl->set_alias ("internal_FRONT_END_ID         ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	min = max+1;
      }
    if(_param->_have_port_ooo_engine_id   )
      {
	size = _param->_size_ooo_engine_id;
	max = min-1+size;
	vhdl->set_alias ("internal_OOO_ENGINE_ID        ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	min = max+1;
      }
    if(_param->_have_port_rob_id   )
      {
	size = _param->_size_rob_id;
	max = min-1+size;
	vhdl->set_alias ("internal_ROB_ID               ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
	min = max+1;
      }

    size = _param->_size_operation;
    max = min-1+size;
    vhdl->set_alias ("internal_OPERATION            ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_type;
    max = min-1+size;
    vhdl->set_alias ("internal_TYPE                 ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_HAS_IMMEDIAT         ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_general_data;
    max = min-1+size;
    vhdl->set_alias ("internal_IMMEDIAT             ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_READ_RA              ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_general_register;
    max = min-1+size;
    vhdl->set_alias ("internal_NUM_REG_RA           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_READ_RB              ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_general_register;
    max = min-1+size;
    vhdl->set_alias ("internal_NUM_REG_RB           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_READ_RC              ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_special_register;
    max = min-1+size;
    vhdl->set_alias ("internal_NUM_REG_RC           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_WRITE_RD             ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_general_register;
    max = min-1+size;
    vhdl->set_alias ("internal_NUM_REG_RD           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_WRITE_RE             ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_special_register;
    max = min-1+size;
    vhdl->set_alias ("internal_NUM_REG_RE           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;


    log_printf(FUNC,Read_queue,"vhdl_declaration","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
