/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  Parameters::Parameters (bool     have_bht               ,
			  uint32_t bht_size_history       ,
			  uint32_t bht_size_address       ,
			  bool     have_pht               ,
			  uint32_t pht_size_address       ,
			  uint32_t pht_size_address_share ,
			  uint32_t size_address           ,
			  uint32_t nb_prediction          ,
			  uint32_t nb_branch_complete     ):
    _have_bht                (have_bht               ),
    _bht_size_history        (bht_size_history       ),
    _bht_size_address        (bht_size_address       ),
    _have_pht                (have_pht               ),
    _pht_size_address        (pht_size_address       ),
    _pht_size_address_share  (pht_size_address_share ),
    _size_address            (size_address           ),
    _nb_prediction           (nb_prediction          ),
    _nb_branch_complete      (nb_branch_complete     ),
    _pht_size_address_shift  (bht_size_history-pht_size_address_share)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"Parameters","Begin");
    test();
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"Parameters","End");
  };
  
  Parameters::Parameters (Parameters & param):
    _have_bht                (param._have_bht               ),
    _bht_size_history        (param._bht_size_history       ),
    _bht_size_address        (param._bht_size_address       ),
    _have_pht                (param._have_pht               ),
    _pht_size_address        (param._pht_size_address       ),
    _pht_size_address_share  (param._pht_size_address_share ),
    _size_address            (param._size_address           ),
    _nb_prediction           (param._nb_prediction          ),
    _nb_branch_complete      (param._nb_branch_complete     ),
    _pht_size_address_shift  (param._pht_size_address_shift )
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"Parameters","Begin");
    test();
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"Parameters","End");
  };

  Parameters::~Parameters () 
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"~Parameters","Begin");
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"~Parameters","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
