#ifndef morpheo_behavioural_generic_registerfile_registerfile_multi_banked_RegisterFile_Multi_Banked_h
#define morpheo_behavioural_generic_registerfile_registerfile_multi_banked_RegisterFile_Multi_Banked_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Statistics.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif

using namespace std;

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  class RegisterFile_Multi_Banked 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string       _name;

  protected : const Parameters * _param;
//#ifdef STATISTICS
//  protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
//#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ----- Interface Read
  public    : SC_IN       (Tcontrol_t)     **  in_READ_VAL     ;
  public    : SC_OUT      (Tcontrol_t)     ** out_READ_ACK     ;
  public    : SC_IN       (Taddress_t)     **  in_READ_ADDRESS ;
  public    : SC_OUT      (Tdata_t)        ** out_READ_DATA    ;

    // ----- Interface Write
  public    : SC_IN       (Tcontrol_t)     **  in_WRITE_VAL    ;
  public    : SC_OUT      (Tcontrol_t)     ** out_WRITE_ACK    ;
  public    : SC_IN       (Taddress_t)     **  in_WRITE_ADDRESS;
  public    : SC_IN       (Tdata_t)        **  in_WRITE_DATA   ;

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : SC_REGISTER (Tdata_t)       *** reg_DATA         ;

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : bool                          * internal_WRITE_VAL;
  private   : Taddress_t                    * internal_WRITE_BANK;
  private   : Taddress_t                    * internal_WRITE_NUM_REG;

        // function pointer
  public    : void (morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::*function_transition    ) (void);
  public    : void (morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::*function_genMealy_read ) (void);
  public    : void (morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::*function_genMealy_write) (void);
#endif

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (RegisterFile_Multi_Banked);
#endif
  public  :          RegisterFile_Multi_Banked              (
#ifdef SYSTEMC
					      sc_module_name                                name,
#else					       
					      string                                        name,
#endif					       
#ifdef STATISTICS
					      morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
					      Parameters                                  * param );
					       
  public  :          ~RegisterFile_Multi_Banked             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)

  private : Taddress_t address_bank                 (Taddress_t address);
  private : Taddress_t address_num_reg              (Taddress_t address);

  public  : void     transition                     (void);
  public  : void     genMealy_read                  (void);
  public  : void     genMealy_write                 (void);

  public  : void     full_crossbar_transition       (void);
  public  : void     full_crossbar_genMealy_read    (void);
  public  : void     full_crossbar_genMealy_write   (void);

  public  : void     partial_crossbar_transition    (void);
  public  : void     partial_crossbar_genMealy_read (void);
  public  : void     partial_crossbar_genMealy_write(void);

//#endif
#endif					       
#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_transition (void);
#endif
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
