#!/bin/sh

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage   : $0 min max [step [iter]]";
    echo " * min  : value minimal";
    echo " * max  : value maximal";
    echo " * step : step between two value. If no present, step = \"+1\"";
    echo " * iter : choose the Nime value";
    exit;
}

#-----[ range ]---------------------------------------------
function range ()
{
    declare a=$1;
    declare b=$2;
    declare step=$3;

    while test $a -lt $b; do
        echo $a;
        a=$(($a $step));
    done

    if test $a -eq $b; then
	echo $a;
    fi;
}

#-----[ range_max ]-----------------------------------------
function range_max ()
{
    declare a=$1;
    declare b=$2;
    declare step=$3;
    declare iter=$4;

    while test $a -lt $b -a $iter -gt 1; do
	a=$(($a $step));
	iter=$(($iter-1));
    done;

    if test $a -eq $b; then
	echo $a;
    fi;

    if test $iter -eq 1; then
	echo $a;
    fi;
}

#-----[ main ]----------------------------------------------
function main ()
{
    # create operande
    case $# in
	2) range $* "+1";;
	3) range $*     ;;
	4) range_max $* ;;
	*) usage $*
    esac
}

#-----[ Corps ]---------------------------------------------
main $*
