#ifndef DEBUG_H
#define DEBUG_H

#include "Common/include/Message.h"
#include "Behavioural/include/Debug_component.h"
#include <stdio.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include <string>

// Debug's Level :
//  * None    : print elementary information
//  * Info    : print basic information
//  * Trace   : trace internal variable
//  * Func    : trace call and return function
//  * All     : print all information

enum _debug_verbosity 
  {
    DEBUG_NONE ,
    DEBUG_INFO ,
    DEBUG_TRACE,
    DEBUG_FUNC ,
    DEBUG_ALL
  };

#ifdef DEBUG
//Debug
#  define log_printf(level, component, func, str... )                   \
  do									\
    {									\
      if ((DEBUG == DEBUG_ALL ) or					\
	  (DEBUG_ ## level == DEBUG_NONE) or				\
	  (( DEBUG_ ## level     <= DEBUG) and				\
	   ( DEBUG_ ## component == true )) )				\
	{								\
	  if (DEBUG >= DEBUG_ALL )					\
	    {								\
	      switch (DEBUG_ ## level)					\
		{							\
		case DEBUG_NONE  : msg(_("(none       ) ")); break;	\
		case DEBUG_INFO  : msg(_("(information) ")); break;	\
		case DEBUG_TRACE : msg(_("(trace      ) ")); break;	\
		case DEBUG_FUNC  : msg(_("(function   ) ")); break;	\
		case DEBUG_ALL   : msg(_("(all        ) ")); break;	\
		default          : msg(_("(undefine   ) ")); break;	\
		}							\
	    }								\
	  msg(_("<%s> "),func);						\
	  if (DEBUG >= DEBUG_FUNC)					\
	    {								\
	      msg(_("In file %s, "),__FILE__);				\
	      msg(_("at line %d, "),__LINE__);				\
	    }								\
	  msg(_(": "));							\
	  msg(str);							\
	  msg(_("\n"));							\
	  fflush (stdout);						\
	}								\
    } while(0)

#else
// No debug

#  define log_printf(level, component, func, str... )                                 \
do                                                                                    \
{                                                                                     \
} while(0)

#endif // DEBUG

#endif // !DEBUG_H
