#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_functionnal_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_execute_unit_execute_unit_functionnal_unit_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Types.h"
#include "Behavioural/Custom/include/Custom.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t            _nb_context                   ;
  public : const uint32_t            _nb_front_end                 ;
  public : const uint32_t            _nb_ooo_engine                ;
  public : const uint32_t            _nb_packet                    ;
  public : const uint32_t            _size_general_data            ;
  public : const uint32_t            _nb_general_register          ;
  public : const uint32_t            _size_special_data            ;
  public : const uint32_t            _nb_special_register          ;
  public : const uint32_t            _nb_operation                 ;
  public : const uint32_t            _nb_type                      ;
  public : const execute_timing_t  * _timing                       ;
  public : morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (uint32_t);

  public : const uint32_t            _size_context_id              ;
  public : const uint32_t            _size_front_end_id            ;
  public : const uint32_t            _size_ooo_engine_id           ;
  public : const uint32_t            _size_packet_id               ;
  public : const uint32_t            _size_general_register        ;
  public : const uint32_t            _size_special_register        ;
  public : const uint32_t            _size_operation               ;
  public : const uint32_t            _size_type                    ;

  public : const bool                _have_port_context_id         ;
  public : const bool                _have_port_front_end_id       ;
  public : const bool                _have_port_ooo_engine_id      ;
  public : const bool                _have_port_packet_id          ;

  public : const bool                _have_groupe_MAC              ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t           nb_context         ,
			uint32_t           nb_front_end       ,
			uint32_t           nb_ooo_engine      ,
			uint32_t           nb_packet          ,
			uint32_t           size_general_data  ,
			uint32_t           nb_general_register,
			uint32_t           size_special_data  ,
			uint32_t           nb_special_register,
			uint32_t           nb_operation       ,
			uint32_t           nb_type            ,
			execute_timing_t * timing             ,
			morpheo::behavioural::custom::custom_information_t (*get_custom_information) (uint32_t));
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        std::string   msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					  morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::functionnal_unit::Parameters & x);
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
