#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace meta_predictor_glue {


  void Meta_Predictor_Glue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_declaration","Begin");

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	if (_param._predictor_0_have_pht)
	  vhdl->set_alias ("predict_"+toString(i)+"_predictor_0_direction",std_logic(1), "in_PREDICT_"+toString(i)+"_PREDICTOR_0_PHT_HISTORY",std_logic_range(_param._predictor_0_pht_size_counter-1,_param._predictor_0_pht_size_counter-1));
	else
	  vhdl->set_alias ("predict_"+toString(i)+"_predictor_0_direction",std_logic(1), "in_PREDICT_"+toString(i)+"_PREDICTOR_0_BHT_HISTORY",std_logic_range(_param._predictor_0_bht_size_shifter-1,_param._predictor_0_bht_size_shifter-1));
	if (_param._predictor_1_have_pht)
	  vhdl->set_alias ("predict_"+toString(i)+"_predictor_1_direction",std_logic(1), "in_PREDICT_"+toString(i)+"_PREDICTOR_1_PHT_HISTORY",std_logic_range(_param._predictor_1_pht_size_counter-1,_param._predictor_1_pht_size_counter-1));
	else
	  vhdl->set_alias ("predict_"+toString(i)+"_predictor_1_direction",std_logic(1), "in_PREDICT_"+toString(i)+"_PREDICTOR_1_BHT_HISTORY",std_logic_range(_param._predictor_1_bht_size_shifter-1,_param._predictor_1_bht_size_shifter-1));
	  }

	if (_param._predictor_2_have_pht)
	  vhdl->set_alias ("predict_"+toString(i)+"_predictor_2_direction",std_logic(1), "in_PREDICT_"+toString(i)+"_PREDICTOR_2_PHT_HISTORY",std_logic_range(_param._predictor_2_pht_size_counter-1,_param._predictor_2_pht_size_counter-1));
	else
	  vhdl->set_alias ("predict_"+toString(i)+"_predictor_2_direction",std_logic(1), "in_PREDICT_"+toString(i)+"_PREDICTOR_2_BHT_HISTORY",std_logic_range(_param._predictor_2_bht_size_shifter-1,_param._predictor_2_bht_size_shifter-1));
      }

    if (_param._have_meta_predictor)
      {
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
// 	if (_param._predictor_2_have_pht)
// 	vhdl->set_alias ("branch_complete_"+toString(i)+"_predictor_2_direction",std_logic(1)," in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY",std_logic_range(_param._shift_6-1, _param._shift_6-1));
// 	else
// 	vhdl->set_alias ("branch_complete_"+toString(i)+"_predictor_2_direction",std_logic(1)," in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY",std_logic_range(_param._shift_5-1, _param._shift_5-1));

	if (_param._predictor_1_have_pht)
	vhdl->set_alias ("branch_complete_"+toString(i)+"_predictor_1_direction",std_logic(1)," in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY",std_logic_range(_param._shift_4-1, _param._shift_4-1));
	else
	vhdl->set_alias ("branch_complete_"+toString(i)+"_predictor_1_direction",std_logic(1)," in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY",std_logic_range(_param._shift_3-1, _param._shift_3-1));

	if (_param._predictor_0_have_pht)
	vhdl->set_alias ("branch_complete_"+toString(i)+"_predictor_0_direction",std_logic(1)," in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY",std_logic_range(_param._shift_2-1, _param._shift_2-1));
	else
	vhdl->set_alias ("branch_complete_"+toString(i)+"_predictor_0_direction",std_logic(1)," in_BRANCH_COMPLETE_"+toString(i)+"_HISTORY",std_logic_range(_param._shift_1-1, _param._shift_1-1));

      }
      }

    log_printf(FUNC,Meta_Predictor_Glue,"vhdl_declaration","End");
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
#endif
