/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


#ifdef SYSTEMC
  Two_Level_Branch_Predictor_Glue::Two_Level_Branch_Predictor_Glue (sc_module_name name,
#else
  Two_Level_Branch_Predictor_Glue::Two_Level_Branch_Predictor_Glue (string name,
#endif
#ifdef STATISTICS
								    morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
								    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::two_level_branch_predictor_glue::Parameters param ):
								    _name              (name)
								    ,_param            (param)
// #ifdef STATISTICS
//								    ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"Two_Level_Branch_Predictor_Glue","Begin");

    allocation ();

#ifdef STATISTICS
    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
#endif

    SC_METHOD (genMealy_predict_ack);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_bht)
	sensitive << (*(in_PREDICT_BHT_ACK     [i]));
	if (_param._have_pht)
	sensitive << (*(in_PREDICT_PHT_ACK     [i]));
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_bht)
	  (*(out_PREDICT_ACK         [i])) (*(in_PREDICT_BHT_ACK     [i]));
	if (_param._have_pht)
	  (*(out_PREDICT_ACK         [i])) (*(in_PREDICT_PHT_ACK     [i]));
      }
#endif
    
    if (_param._have_bht)
      {
	SC_METHOD (genMealy_predict_bht_address);
	dont_initialize ();
	sensitive_neg << *(in_CLOCK);
	for (uint32_t i=0; i<_param._nb_prediction; i++)
	  sensitive << (*(in_PREDICT_ADDRESS     [i]));
	
#ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param._nb_prediction; i++)
	  (*(out_PREDICT_BHT_ADDRESS [i])) (*(in_PREDICT_ADDRESS     [i]));
#endif
      }

    if (_param._have_pht)
      {
	SC_METHOD (genMealy_predict_pht_address);
	dont_initialize ();
	sensitive_neg << *(in_CLOCK);
	for (uint32_t i=0; i<_param._nb_prediction; i++)
	  {
	    if (_param._have_bht)
	      sensitive << (*(in_PREDICT_BHT_HISTORY [i]));
	    sensitive << (*(in_PREDICT_ADDRESS     [i]));
	  }
	
#ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param._nb_prediction; i++)
	  {
	    (*(out_PREDICT_PHT_ADDRESS [i])) (*(in_PREDICT_ADDRESS     [i]));
	    if (_param._have_bht)
	      (*(out_PREDICT_PHT_ADDRESS [i])) (*(in_PREDICT_BHT_HISTORY [i]));
	  }
#endif
      }

    SC_METHOD (genMealy_branch_complete_ack);
    dont_initialize ();
    sensitive_neg << *(in_CLOCK);
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_bht)
	sensitive << (*(in_BRANCH_COMPLETE_BHT_ACK     [i]));
	if (_param._have_pht)
	sensitive << (*(in_BRANCH_COMPLETE_PHT_ACK     [i]));
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_bht)
	  (*(out_BRANCH_COMPLETE_ACK         [i])) (*(in_BRANCH_COMPLETE_BHT_ACK     [i]));
	if (_param._have_pht)
	  (*(out_BRANCH_COMPLETE_ACK         [i])) (*(in_BRANCH_COMPLETE_PHT_ACK     [i]));
      }
#endif
    
    if (_param._have_bht)
      {
	SC_METHOD (genMealy_branch_complete_bht_address);
	dont_initialize ();
	sensitive_neg << *(in_CLOCK);
	for (uint32_t i=0; i<_param._nb_branch_complete; i++)
	  sensitive << (*(in_BRANCH_COMPLETE_ADDRESS     [i]));
	
#ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param._nb_branch_complete; i++)
	  (*(out_BRANCH_COMPLETE_BHT_ADDRESS [i])) (*(in_BRANCH_COMPLETE_ADDRESS     [i]));
#endif
      }

    if (_param._have_pht)
      {
	SC_METHOD (genMealy_branch_complete_pht_address);
	dont_initialize ();
	sensitive_neg << *(in_CLOCK);
	for (uint32_t i=0; i<_param._nb_branch_complete; i++)
	  {
	    if (_param._have_bht)
	      sensitive << (*(in_BRANCH_COMPLETE_BHT_HISTORY [i]));
	    sensitive << (*(in_BRANCH_COMPLETE_ADDRESS     [i]));
	  }
	
#ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param._nb_branch_complete; i++)
	  {
	    (*(out_BRANCH_COMPLETE_PHT_ADDRESS [i])) (*(in_BRANCH_COMPLETE_ADDRESS     [i]));
	    if (_param._have_bht)
	      (*(out_BRANCH_COMPLETE_PHT_ADDRESS [i])) (*(in_BRANCH_COMPLETE_BHT_HISTORY [i]));
	  }
#endif
      }

#endif
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"Two_Level_Branch_Predictor_Glue","End");
  };
  
  Two_Level_Branch_Predictor_Glue::~Two_Level_Branch_Predictor_Glue (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"~Two_Level_Branch_Predictor_Glue","Begin");

#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    deallocation ();
#endif

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"~Two_Level_Branch_Predictor_Glue","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction


}; // end namespace behavioural
}; // end namespace morpheo              
