#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  void Meta_Predictor::vhdl_port (Vhdl & vhdl)
  {
    log_printf(FUNC,Meta_Predictor,"vhdl_port","Begin");

    vhdl.set_port (" in_CLOCK ", IN, 1);
    vhdl.set_port (" in_NRESET", IN, 1);

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl.set_port (" in_PREDICT_VAL_"+toString(i)+"                ", IN, 1);
	vhdl.set_port ("out_PREDICT_ACK_"+toString(i)+"                ",OUT, 1);
	vhdl.set_port (" in_PREDICT_ADDRESS_"+toString(i)+"            ", IN,_param._size_address);
	vhdl.set_port ("out_PREDICT_HISTORY_"+toString(i)+"            ",OUT,_param._size_history);
    	vhdl.set_port ("out_PREDICT_DIRECTION_"+toString(i)+"          ",OUT,1);
      }

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl.set_port (" in_BRANCH_COMPLETE_VAL_"+toString(i)+"        ", IN, 1);
	vhdl.set_port ("out_BRANCH_COMPLETE_ACK_"+toString(i)+"        ",OUT, 1);
	vhdl.set_port (" in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"    ", IN,_param._size_address);
	vhdl.set_port (" in_BRANCH_COMPLETE_HISTORY_"+toString(i)+"    ", IN,_param._size_history);
	vhdl.set_port (" in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"  ", IN, 1);
      }
    
    log_printf(FUNC,Meta_Predictor,"vhdl_port","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
