/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/include/Parameters.h"
#include "Behavioural/include/XML.h"
using namespace std;

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {


  string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Meta_Predictor,"print","Begin");

    uint32_t size_predictor_0 = _predictor_0_bht_size_shifter*_predictor_0_bht_nb_shifter+_predictor_0_pht_size_counter*_predictor_0_pht_nb_counter;
    uint32_t size_predictor_1 = _predictor_1_bht_size_shifter*_predictor_1_bht_nb_shifter+_predictor_1_pht_size_counter*_predictor_1_pht_nb_counter;
    uint32_t size_predictor_2 = _predictor_2_bht_size_shifter*_predictor_2_bht_nb_shifter+_predictor_2_pht_size_counter*_predictor_2_pht_nb_counter;
    uint32_t size_predictor   = size_predictor_0+size_predictor_1+size_predictor_2;

    XML xml ("meta_predictor");
    xml.balise_open("meta_predictor");

    xml.  text("");
    xml.  comment("size predictor   : "+toString(size_predictor  )+" bits");
    xml.  comment("size predictor_0 : "+toString(size_predictor_0)+" bits");
    xml.  comment("size predictor_1 : "+toString(size_predictor_1)+" bits");
    xml.  comment("size predictor_2 : "+toString(size_predictor_2)+" bits");
    xml.  text("");

    xml.  singleton_begin("have_meta_predictor               ");               
    xml.    attribut("value",toString(_have_meta_predictor               ));
    xml.  singleton_end();

    xml.  singleton_begin("predictor_0_have_bht              ");        	
    xml.    attribut("value",toString(_predictor_0_have_bht              ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_0_bht_size_shifter      ");	
    xml.    attribut("value",toString(_predictor_0_bht_size_shifter      ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_0_bht_nb_shifter        ");        
    xml.    attribut("value",toString(_predictor_0_bht_nb_shifter        ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_0_have_pht              ");              
    xml.    attribut("value",toString(_predictor_0_have_pht              ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_0_pht_size_counter      ");      
    xml.    attribut("value",toString(_predictor_0_pht_size_counter      ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_0_pht_nb_counter        ");        
    xml.    attribut("value",toString(_predictor_0_pht_nb_counter        ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_0_pht_size_address_share");
    xml.    attribut("value",toString(_predictor_0_pht_size_address_share));
    xml.  singleton_end();

    xml.  singleton_begin("predictor_1_have_bht              ");        	
    xml.    attribut("value",toString(_predictor_1_have_bht              ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_1_bht_size_shifter      ");	
    xml.    attribut("value",toString(_predictor_1_bht_size_shifter      ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_1_bht_nb_shifter        ");        
    xml.    attribut("value",toString(_predictor_1_bht_nb_shifter        ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_1_have_pht              ");              
    xml.    attribut("value",toString(_predictor_1_have_pht              ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_1_pht_size_counter      ");      
    xml.    attribut("value",toString(_predictor_1_pht_size_counter      ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_1_pht_nb_counter        ");        
    xml.    attribut("value",toString(_predictor_1_pht_nb_counter        ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_1_pht_size_address_share");
    xml.    attribut("value",toString(_predictor_1_pht_size_address_share));
    xml.  singleton_end();
    
    xml.  singleton_begin("predictor_2_have_bht              ");        	
    xml.    attribut("value",toString(_predictor_2_have_bht              ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_2_bht_size_shifter      ");	
    xml.    attribut("value",toString(_predictor_2_bht_size_shifter      ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_2_bht_nb_shifter        ");        
    xml.    attribut("value",toString(_predictor_2_bht_nb_shifter        ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_2_have_pht              ");              
    xml.    attribut("value",toString(_predictor_2_have_pht              ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_2_pht_size_counter      ");      
    xml.    attribut("value",toString(_predictor_2_pht_size_counter      ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_2_pht_nb_counter        ");        
    xml.    attribut("value",toString(_predictor_2_pht_nb_counter        ));
    xml.  singleton_end();
    xml.  singleton_begin("predictor_2_pht_size_address_share");
    xml.    attribut("value",toString(_predictor_2_pht_size_address_share));
    xml.  singleton_end();
        
    xml.  singleton_begin("size_address                      ");                      
    xml.    attribut("value",toString(_size_address          ));
    xml.  singleton_end();
    xml.  singleton_begin("nb_prediction                     ");                     
    xml.    attribut("value",toString(_nb_prediction         ));
    xml.  singleton_end();
    xml.  singleton_begin("nb_branch_complete                ");                
    xml.    attribut("value",toString(_nb_branch_complete    ));
    xml.  singleton_end();
    
    if (_have_meta_predictor)
      {
    xml.  text(_param_two_level_branch_predictor_0->print(depth+1));
    xml.  text(_param_two_level_branch_predictor_1->print(depth+1));
      }
    xml.  text(_param_two_level_branch_predictor_2->print(depth+1));
    xml.  text(_param_meta_predictor_glue         ->print(depth+1));

    xml.balise_close();

    log_printf(FUNC,Meta_Predictor,"print","End");
    
    return xml.get_body(depth);
  };

  ostream& operator<< (ostream& output_stream ,
		       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::Parameters & x)
  {
    output_stream << x.print(0);
    
    return output_stream;
  };

}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              
