#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interfaces.h"
#include "Behavioural/include/Entity.h"

namespace morpheo              {
namespace behavioural          {

  string Interfaces::testbench_body (Vhdl * & vhdl,
				     string   counter_name,
				     string   reset_name  )
  {
    log_printf(FUNC,Behavioural,"testbench_body","Begin");

    string test      = "'1'";
    string test_name = "test";
    vhdl->set_signal(test_name,1);

    if (_list_interface->empty()== false)
      {
	list<Interface_fifo*>::iterator i = _list_interface->begin();

	while (i != _list_interface->end())
	  {
	    (*i)->testbench_body(vhdl, counter_name, reset_name);
	    string str = (*i)->testbench_test(vhdl, counter_name, reset_name);

	    test += " and "+str;
	    ++i;
	  }
      }

    vhdl->set_body("");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("-- Test");
    vhdl->set_body("------------------------------------------------------");
    vhdl->set_body("");
    vhdl->set_body(test_name + " <= "+test+";");
    vhdl->set_body("");

    log_printf(FUNC,Behavioural,"testbench_body","End");

    return test_name;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
