#ifndef morpheo_BitManipulation
#define morpheo_BitManipulation

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>

namespace morpheo              {

  //............................................................................
  // gen_mask ..................................................................
  //............................................................................
  
  template <typename T>
  T gen_mask       (uint32_t size) 
  { 
    T mask = 0; 
    for (uint32_t i=0; i<size; i++)
      {
	mask <<= 1;
	mask  |= 1;
      }
    return mask;
  };

  template <typename T>
  T gen_mask       (uint32_t index_max, uint32_t index_min) 
  { 
    return  (gen_mask<T>(index_max-index_min+1)<<index_min);
  };

  template <typename T>
  T gen_mask_not   (uint32_t index_max, uint32_t index_min) 
  { 
    return ~(gen_mask<T>(index_max-index_min+1)<<index_min);
  };

  //............................................................................
  // mask, mask_not ............................................................
  //............................................................................
  template <typename T>
  T mask           (T data, uint32_t index_max, uint32_t index_min)  
  {
    return gen_mask    <T>(index_max,index_min) & data;
  }

  template <typename T>
  T mask_not       (T data, uint32_t index_max, uint32_t index_min)  
  {
    return gen_mask_not<T>(index_max,index_min) & data;
  }

  //............................................................................
  // shift_left_logic, shift_right_logic .......................................
  //............................................................................
  template <typename T>
  T shift_logic_left (uint32_t size, T data, T value)  
  {
    T mask = gen_mask<T> (size);

    return (mask & ((mask & data) << value));
  }

  template <typename T>
  T shift_logic_right (uint32_t size, T data, T value)  
  {
    T mask = gen_mask<T> (size);

    return (mask & ((mask & data) >> value));
  }

  //............................................................................
  // shift_logic ...............................................................
  //............................................................................
  template <typename T>
  T shift_logic      (uint32_t size, T data, T value, bool is_direction_left)
  {
    if (is_direction_left == true)
      return shift_logic_left  <T> (size, data, value);
    else
      return shift_logic_right <T> (size, data, value);
  }

  //............................................................................
  // shift_left_arithmetic, shift_right_arithmetic .............................
  //............................................................................
  template <typename T>
  T shift_arithmetic_left (uint32_t size, T data, T value)  
  {
    bool carry = (data&1) != 0;

    if (carry == false)
      return shift_logic_left <T> (size,data,value);
    else
      {
	if (value > size)
	  return gen_mask<T> (size);

	T mask = gen_mask<T> (value);
	return shift_logic_left <T> (size,data,value) | mask;
      }
  }


  template <typename T>
  T shift_arithmetic_right (uint32_t size, T data, T value)  
  {
    bool carry = (data&(1<<(size-1))) != 0;

    if (carry == false)
      return shift_logic_right <T> (size,data,value);
    else
      {
	if (value > size)
	  return gen_mask<T> (size);
	
	T mask = gen_mask<T> (value) << (size-value);
	return ((shift_logic_right <T> (size,data,value)) | mask);
      }
  }

  //............................................................................
  // shift_arithmetic ..........................................................
  //............................................................................
  template <typename T>
  T shift_arithmetic      (uint32_t size, T data, T value, bool is_direction_left)
  {
    if (is_direction_left == true)
      return shift_arithmetic_left  <T> (size, data, value);
    else
      return shift_arithmetic_right <T> (size, data, value);
  }

  //............................................................................
  // shift .....................................................................
  //............................................................................
  template <typename T>
  T shift            (uint32_t size, T data, T value, bool is_direction_left, bool is_shift_arithmetic)
  {
    if (is_shift_arithmetic == true)
      return shift_arithmetic <T> (size, data, value, is_direction_left);
    else
      return shift_logic      <T> (size, data, value, is_direction_left);
  }

  //............................................................................
  // rotate_left, rotate_right .................................................
  //............................................................................
  template <typename T>
  T rotate_left    (uint32_t size, T data, T value)  
  {
    T mask        = gen_mask<T> (size);
    T rotate_mask = gen_mask<T> (value);
    T rotate      = rotate_mask & shift_logic_right<T>(size,data,size-value);
    return (mask & (shift_logic_left <T> (size, data, value) | rotate));
  }

  template <typename T>
  T rotate_right    (uint32_t size, T data, T value)  
  {
    T mask        = gen_mask<T> (size);
    T rotate_mask = gen_mask<T> (value);
    T rotate      = shift_logic_left <T> (size,rotate_mask & data,size-value);
    return (mask & (shift_logic_right<T> (size, data, value) | rotate));
  }

  //............................................................................
  // rotate ....................................................................
  //............................................................................
  template <typename T>
  T rotate         (uint32_t size, T data, T value, bool is_direction_left)  
  {
    if (is_direction_left == true)
      return rotate_left  <T> (size, data, value);
    else
      return rotate_right <T> (size, data, value);
  }

  //............................................................................
  // range .....................................................................
  //............................................................................
  template <typename T>
  T range          (T data, uint32_t index_max, uint32_t index_min)  
  {
    return (mask<T>(data,index_max,index_min) >> index_min);
  }

  template <typename T>
  T range          (T data, uint32_t nb_bits)  
  {
    return gen_mask<T>(nb_bits) & data;
  }

  //............................................................................
  // insert ....................................................................
  //............................................................................
  template <typename T>
  T insert         (T data_old, T data_new, uint32_t index_max, uint32_t index_min)  
  {
    return (mask<T>(data_new,index_max,index_min) | mask_not<T>(data_old,index_max,index_min));
  }

  //............................................................................
  // extend ....................................................................
  //............................................................................
  template <typename T>
  T extend         (uint32_t size, T data, bool extend_with_sign, uint32_t nb_bits_keep)
  {
    if (size < nb_bits_keep)
      return data;

    if (extend_with_sign and ((data>>(nb_bits_keep-1))&1))
      return data | (mask<T>(gen_mask<T>(size),size-1, nb_bits_keep));
    else
      return data & (mask<T>(gen_mask<T>(size),nb_bits_keep-1, 0));
  }

  //............................................................................
  // duplicate..................................................................
  //............................................................................

  template <typename T>
  T duplicate (uint32_t size, T data_src, uint32_t nb_bits, uint32_t index_min)
  {
    T data_duplicate = mask<T>((data_src)>>index_min, nb_bits-1, 0);
    T data_dest      = 0;
    
    for (uint32_t i=0; i < size; i+=nb_bits)
      data_dest |= (data_duplicate<<i);
    
    return data_dest;
  }

  template <typename T>
  T duplicate (uint32_t size, T data_src, uint32_t nb_bits)
  {
    return duplicate<T> (size,data_src,nb_bits,0);
  }


}; // end namespace morpheo              

#endif
