#ifndef morpheo_tools_viewer_bdd_baseV_h
#define morpheo_tools_viewer_bdd_baseV_h

#include <iostream>
#include <list>
#include <iterator>
#include <qlist.h>
#include <qmap.h>
#include "Tools/Viewer/Bdd/include/LimitParam.h"
#include "Tools/Viewer/Bdd/include/Group.h"
#include "Tools/Viewer/Bdd/include/Param.h"


#include "Tools/Viewer/Bdd/include/BaseP.h"
#include "Tools/Viewer/Bdd/include/Signal.h"

using namespace std;
namespace morpheo{
namespace tools{
namespace viewer{
namespace bdd{     

  class BaseV
    {
    private:
      string comment;
      QList<morpheo::tools::viewer::bdd::BaseP> *pos;
      QList<string> *listcomp; //dico index
      /*list of groups(singleton)*/
      QList<string> *listgroup; //dico index
      QList<morpheo::tools::viewer::bdd::Group> *groups;
      /*list of limit parameters names*/
      QMap<string,morpheo::tools::viewer::bdd::LimitParam> *limitp;
      /*list of sources link(generation file)*/
      QMap<string,string> *link_src;
      /*list of destination link(generation file)*/
      QMap<string,string> *link_dest;

    protected:
    public:
      //accessors
      morpheo::tools::viewer::bdd::BaseP get_BasePos(string v);
      morpheo::tools::viewer::bdd::Signal *getSignal(morpheo::tools::viewer::bdd::BaseP *top,string c,PortMap *dest);
      QList<morpheo::tools::viewer::bdd::BaseP>  *getBaseP();
      string getLinksrc(string name);
      string getLinkdest(string name);
      void setComment(string s);

      //constructors
      BaseV();
      ~BaseV ();
      
      void addBaseP(morpheo::tools::viewer::bdd::BaseP *p,string t);
      /*search a group*/
      morpheo::tools::viewer::bdd::Group searchGroup(string v);
      ///*search a param*/
      //morpheo::tools::viewer::bdd::Param searchParam(string group,string v);
      /*search a limitparam*/
      morpheo::tools::viewer::bdd::LimitParam searchLimitParam(string v);

      /*modify a parameter value*/
      void modifyValue(string nomgroup,string nameparam,int value);

      /*add/remove group*/
      int modifyGroup(string namegroup,int step);
      int nbGroup(string namegroup);

      /*add a source link */
      void addLinksrc(string name,string src);
      /*add a dest link */
      void addLinkdest(string name,string dest);
      
      /*add a group with his level*/
      void addGroup(morpheo::tools::viewer::bdd::Group *g);
      /*add limit param*/
      void addLimitParam(morpheo::tools::viewer::bdd::LimitParam *lp);
      /*take group list*/
      QList<morpheo::tools::viewer::bdd::Group> *getGroups();
      /*take LimitParam list*/
      QList<morpheo::tools::viewer::bdd::LimitParam> getLimitParam();
      /*debug*/
      void afficheLimitParamConsole();
      void afficheParamConsole();
      void afficheBaseConsole();
    };//end class BaseV

};//end bdd
};//end viewer
};//end tools
};//end morpheo

#endif
