#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Read_unit_to_Execution_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::genMealy"
  void Read_unit_to_Execution_unit::genMealy (void)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"Begin");

    bool execute_unit_use [_param->_nb_execute_unit];

    for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
      execute_unit_use[i] = (PORT_READ(in_EXECUTE_UNIT_IN_ACK [i]) == 0);

    for (uint32_t i=0; i<_param->_nb_read_unit; i++)
      {
	bool       ack = false;

	log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"Test Read_unit[%d]",i);

	if (PORT_READ(in_READ_UNIT_OUT_VAL [i]) == true)
	  {
	    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION," * have a valid entry.");
	    
	    Tcontext_t context_id    = (_param->_have_port_context_id   )?PORT_READ(in_READ_UNIT_OUT_CONTEXT_ID    [i]):0;
	    Tcontext_t front_end_id  = (_param->_have_port_front_end_id )?PORT_READ(in_READ_UNIT_OUT_FRONT_END_ID  [i]):0;
	    Tcontext_t ooo_engine_id = (_param->_have_port_ooo_engine_id)?PORT_READ(in_READ_UNIT_OUT_OOO_ENGINE_ID [i]):0;
	    Tcontext_t num_thread    = get_num_thread(context_id   , _param->_size_context_id   ,
						      front_end_id , _param->_size_front_end_id ,
						      ooo_engine_id, _param->_size_ooo_engine_id);
	    Ttype_t    type          = PORT_READ(in_READ_UNIT_OUT_TYPE [i]);
	    
#ifdef DEBUG_TEST
	    if (_destination[i][num_thread][type].empty())
	      throw ERRORMORPHEO(FUNCTION,"Invalid Operation : They have no execute_unit to receive a operation from the read_unit ["+toString(i)+"], thread ["+toString(num_thread)+"] and a operation's type ["+toString_type(type)+"].");
#endif

	    // find a free execute_unit
	    for (std::list<uint32_t>::iterator it=_destination[i][num_thread][type].begin();
		 (it != _destination[i][num_thread][type].end()) and (ack == false);
		 it++)
	      {
		uint32_t dest = *it;

		log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"   * Test destination [%d].",dest);
			    
		if (execute_unit_use [dest] == false)
		  {
		    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"     * Is ok! Link.");
		    // have find !!!
		    ack                     = true;
		    execute_unit_use [dest] = true;

		    if (_param->_have_port_context_id)
		    PORT_WRITE(out_EXECUTE_UNIT_IN_CONTEXT_ID            [dest], PORT_READ(in_READ_UNIT_OUT_CONTEXT_ID            [i]));
		    if (_param->_have_port_front_end_id)
		    PORT_WRITE(out_EXECUTE_UNIT_IN_FRONT_END_ID          [dest], PORT_READ(in_READ_UNIT_OUT_FRONT_END_ID          [i]));
		    if (_param->_have_port_ooo_engine_id)
		    PORT_WRITE(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID         [dest], PORT_READ(in_READ_UNIT_OUT_OOO_ENGINE_ID         [i]));
		    if (_param->_have_port_packet_id)
		    PORT_WRITE(out_EXECUTE_UNIT_IN_PACKET_ID             [dest], PORT_READ(in_READ_UNIT_OUT_PACKET_ID             [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_OPERATION             [dest], PORT_READ(in_READ_UNIT_OUT_OPERATION             [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_TYPE                  [dest], PORT_READ(in_READ_UNIT_OUT_TYPE                  [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [dest], PORT_READ(in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE  [dest], PORT_READ(in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE  [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT          [dest], PORT_READ(in_READ_UNIT_OUT_HAS_IMMEDIAT          [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_IMMEDIAT              [dest], PORT_READ(in_READ_UNIT_OUT_IMMEDIAT              [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_DATA_RA               [dest], PORT_READ(in_READ_UNIT_OUT_DATA_RA               [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_DATA_RB               [dest], PORT_READ(in_READ_UNIT_OUT_DATA_RB               [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_DATA_RC               [dest], PORT_READ(in_READ_UNIT_OUT_DATA_RC               [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_WRITE_RD              [dest], PORT_READ(in_READ_UNIT_OUT_WRITE_RD              [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_NUM_REG_RD            [dest], PORT_READ(in_READ_UNIT_OUT_NUM_REG_RD            [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_WRITE_RE              [dest], PORT_READ(in_READ_UNIT_OUT_WRITE_RE              [i]));
		    PORT_WRITE(out_EXECUTE_UNIT_IN_NUM_REG_RE            [dest], PORT_READ(in_READ_UNIT_OUT_NUM_REG_RE            [i]));
		  }
	      }
	  }
	PORT_WRITE(out_READ_UNIT_OUT_ACK [i], ack);
      }

    for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
      {
	PORT_WRITE(out_EXECUTE_UNIT_IN_VAL[i], execute_unit_use[i]);  
      }

    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,"End");
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
