#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_register_unit_register_unit_glue_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_register_unit_register_unit_glue_Parameters_h

/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const uint32_t    _nb_ooo_engine        ;
  public : const uint32_t    _size_general_data    ;
  public : const uint32_t    _size_special_data    ;
  public : const uint32_t    _nb_gpr_read          ;
  public : const uint32_t    _nb_spr_read          ;    
  public : const uint32_t    _nb_gpr_write         ;
  public : const uint32_t    _nb_spr_write         ;
  public : const uint32_t  * _nb_inst_insert_rob   ;
  public : const uint32_t  * _nb_inst_retire_rob   ;

  public : const bool        _have_port_ooo_engine_id;
    
    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (const uint32_t   nb_ooo_engine        ,
			const uint32_t   size_general_data    ,
			const uint32_t   size_special_data    ,
			const uint32_t   nb_gpr_read          ,
			const uint32_t   nb_spr_read          ,    
			const uint32_t   nb_gpr_write         ,
			const uint32_t   nb_spr_write         ,
			const uint32_t * nb_inst_insert_rob   ,
			const uint32_t * nb_inst_retire_rob   );
  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        std::string   msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::register_unit_glue::Parameters & x);
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
