#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::allocation (void)
  {
    _component   = new Component ();

    Entity * entity = _component->set_entity (_name                  
					      ,"Select_Priority_Fixed"
#ifdef POSITION
					      ,COMBINATORY           
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface(""
#ifdef POSITION
							      , IN  ,WEST, "Generalist interface"
#endif
							      );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1);
    }

    // ~~~~~[Interface : "access" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
       in_ACCESS_VAL     = new SC_IN (Tcontrol_t) * [_param._nb_access];
      out_ACCESS_ACK     = new SC_OUT(Tcontrol_t) * [_param._nb_access];
      if (_param._size_table>1)
       in_ACCESS_ADDRESS = new SC_IN (Taddress_t) * [_param._nb_access];
      out_ACCESS_ENTITY  = new SC_OUT(Tentity_t ) * [_param._nb_access];
      
      for (uint32_t i=0; i<_param._nb_access; i++)
	{
	  Interface_fifo * interface = _interfaces->set_interface("access_"+toString(i)
#ifdef POSITION
								  , IN  ,WEST, "Access"
#endif
								  );

	   in_ACCESS_VAL     [i] = interface->set_signal_valack_in        ("val"    , VAL);
	  out_ACCESS_ACK     [i] = interface->set_signal_valack_out       ("ack"    , ACK);
	  
	  if (_param._size_table>1)
	   in_ACCESS_ADDRESS [i] = interface->set_signal_in  <Taddress_t> ("address",static_cast<uint32_t>(log2(_param._size_table)));
	  out_ACCESS_ENTITY  [i] = interface->set_signal_out <Tentity_t>  ("entity" ,static_cast<uint32_t>(log2(_param._nb_entity )));
	}
    }

    // ~~~~~[Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    {
       in_UPDATE_VAL     = new SC_IN (Tcontrol_t) *  [_param._nb_update];
      out_UPDATE_ACK     = new SC_OUT(Tcontrol_t) *  [_param._nb_update];
      if (_param._size_table>1)
       in_UPDATE_ADDRESS = new SC_IN (Taddress_t) *  [_param._nb_update];
       in_UPDATE_ENTITY  = new SC_IN (Tentity_t ) *  [_param._nb_update];
      
      for (uint32_t i=0; i<_param._nb_update; i++)
	{
	  Interface_fifo * interface = _interfaces->set_interface("update_"+toString(i)
#ifdef POSITION
								  , IN  ,EAST, "Update"
#endif
								  );

 	  in_UPDATE_VAL     [i] = interface->set_signal_valack_in        ("val"    , VAL);
	 out_UPDATE_ACK     [i] = interface->set_signal_valack_out       ("ack"    , ACK);
	 if (_param._size_table>1)
	  in_UPDATE_ADDRESS [i] = interface->set_signal_in  <Taddress_t> ("address",static_cast<uint32_t>(log2(_param._size_table)));
	  in_UPDATE_ENTITY  [i] = interface->set_signal_in  <Tentity_t>  ("entity" ,static_cast<uint32_t>(log2(_param._nb_entity )));
	}
    }
    // -----[Register ]---------------------------------------------------
    reg_TABLE = new entry_t *  [_param._size_table];

    for (uint32_t i=0; i<_param._size_table; i++)
      reg_TABLE [i] = new entry_t (_param._nb_entity);
    
    // -----[Internal ]---------------------------------------------------
    internal_ACCESS_ENTITY = new Tentity_t [_param._nb_entity];

#ifdef POSITION
    _component->generate_file();
#endif
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
