#include "../include/Cache_OneLevel.h"

namespace environnement {
namespace cache {
namespace cache_onelevel {

  Cache_OneLevel::Cache_OneLevel (std::string name,
				  Parameters * param)
  {
    this->name  = name;
    this->param = param;

    access_port = new Access_Port [param->nb_port];
    tag         = new Tag *       [param->nb_line/param->associativity];
    for (uint32_t it = 0; it < param->nb_line/param->associativity; it ++)
      tag [it] = new Tag [param->associativity];
    
    size_address.offset  = (uint32_t) log2(param->size_line * param->size_word);
    size_address.familly = (uint32_t) log2(param->nb_line/param->associativity);
    size_address.tag     = 32 - size_address.familly - size_address.offset;
    
    param_write_buffer = new queue::Parameters (2);
    
    write_buffer = new queue::Sort_Queue_Dynamic<Write_Buffer> (name+"_write_buffer",param_write_buffer);
  }

  Cache_OneLevel::~Cache_OneLevel (void)
  {
    delete    write_buffer;
    delete    param_write_buffer;
    for (uint32_t it = 0; it < param->nb_line/param->associativity; it ++)
      delete [] tag [it];
    delete [] tag;
    delete [] access_port;
  }
};
};
};
